/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.zoyi.channel.plugin.android.ChannelPlugin;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.userchat_list.UserChatListActivity;
import com.zoyi.channel.plugin.android.event.CommandBus;
import com.zoyi.channel.plugin.android.event.PushBus;
import com.zoyi.channel.plugin.android.event.RxBus;
import com.zoyi.channel.plugin.android.model.rest.Plugin;
import com.zoyi.channel.plugin.android.model.rest.ProfileEntity;
import com.zoyi.channel.plugin.android.model.rest.UserChat;
import com.zoyi.channel.plugin.android.util.IntentUtils;
import com.zoyi.channel.plugin.android.util.Utils;
import com.zoyi.channel.plugin.android.view.external.fab.FloatingActionButton;
import com.zoyi.channel.plugin.android.view.layout.AvatarLayout;
import com.zoyi.rx.Subscription;
import com.zoyi.rx.android.AndroidSchedulers;
import com.zoyi.rx.functions.Action1;

public class ChannelView
extends RelativeLayout {
    View pushLayout;
    AvatarLayout avatarLayout;
    TextView textName;
    TextView textMessage;
    FloatingActionButton fab;
    private Context context;
    private Animation pushAnimation;
    private Subscription subscription;
    private UserChat userChat;

    public ChannelView(Context context) {
        super(context);
    }

    public ChannelView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public ChannelView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(final Context context, AttributeSet attrs) {
        this.context = context;
        View view = LayoutInflater.from((Context)context).inflate(R.layout.ch_plugin_layout_channel_view, (ViewGroup)this);
        this.fab = (FloatingActionButton)view.findViewById(R.id.fab);
        this.fab.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ChannelPlugin.launch(ChannelView.this.context);
            }
        });
        this.pushLayout = view.findViewById(R.id.push_layout);
        this.avatarLayout = (AvatarLayout)view.findViewById(R.id.push_avatar);
        this.textName = (TextView)view.findViewById(R.id.push_name);
        this.textMessage = (TextView)view.findViewById(R.id.push_message);
        this.pushAnimation = AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.push);
        this.pushAnimation.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
                ChannelView.this.pushLayout.setVisibility(0);
            }

            public void onAnimationEnd(Animation animation) {
                ChannelView.this.hidePush();
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
        view.findViewById(R.id.push_close).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ChannelView.this.hidePush();
            }
        });
        this.pushLayout.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                String chatId = ChannelView.this.userChat != null ? ChannelView.this.userChat.getId() : null;
                IntentUtils.setNextActivity(context, UserChatListActivity.class).putExtra("chatId", chatId).startActivity();
            }
        });
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.subscription = RxBus.observable().observeOn(AndroidSchedulers.mainThread()).subscribe((Action1)new Action1<Object>(){

            public void call(Object o) {
                if (o instanceof CommandBus) {
                    CommandBus commandBus = (CommandBus)o;
                    switch (commandBus.getCommand()) {
                        case CHECKED_IN: {
                            if (commandBus.getObject() == null || !(commandBus.getObject() instanceof Plugin)) break;
                            ChannelView.this.checkedIn((Plugin)commandBus.getObject());
                            break;
                        }
                        case CHECKED_OUT: {
                            ChannelView.this.checkedOut();
                        }
                    }
                }
                if (o instanceof PushBus) {
                    PushBus pushBus = (PushBus)o;
                    ChannelView.this.showPush(pushBus.getProfileEntity(), pushBus.getMessage(), pushBus.getUserChat());
                }
            }
        });
        if (ChannelPlugin.getPlugin() != null) {
            this.checkedIn(ChannelPlugin.getPlugin());
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.subscription != null && !this.subscription.isUnsubscribed()) {
            this.subscription.unsubscribe();
        }
    }

    private void checkedIn(Plugin plugin) {
        if (plugin != null) {
            this.setVisibility(0);
            this.fab.setColorNormal(plugin.getBackgroundColor());
            this.fab.setColorPressed(Utils.addBlackMask(plugin.getBackgroundColor()));
            this.fab.setColorRipple(-1);
            this.fab.setImageResource(plugin.getTextColor() == -16777216 ? R.drawable.ch_plugin_balloon_black : R.drawable.ch_plugin_balloon);
            this.fab.setVisibility(0);
        }
    }

    private void checkedOut() {
        this.setVisibility(8);
    }

    private void showPush(ProfileEntity person, String message, UserChat userChat) {
        this.userChat = userChat;
        this.avatarLayout.set(person);
        if (person != null && person.getName() != null) {
            this.textName.setText((CharSequence)person.getName());
        } else {
            this.textName.setText((CharSequence)Utils.getString(this.context, "ch.unknown"));
        }
        this.textMessage.setText((CharSequence)(message != null ? message : ""));
        this.pushLayout.setVisibility(0);
        this.pushLayout.startAnimation(this.pushAnimation);
    }

    private void hidePush() {
        this.userChat = null;
        this.pushLayout.clearAnimation();
        this.pushLayout.setVisibility(8);
    }
}

