/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android;

import android.app.Application;
import android.content.Context;
import android.os.Looper;
import com.zoyi.channel.plugin.android.ChannelStore;
import com.zoyi.channel.plugin.android.CheckIn;
import com.zoyi.channel.plugin.android.activity.userchat_list.UserChatListActivity;
import com.zoyi.channel.plugin.android.enumerate.Command;
import com.zoyi.channel.plugin.android.event.CommandBus;
import com.zoyi.channel.plugin.android.event.RxBus;
import com.zoyi.channel.plugin.android.global.ActivityLifecycleManager;
import com.zoyi.channel.plugin.android.global.PrefSupervisor;
import com.zoyi.channel.plugin.android.model.rest.Plugin;
import com.zoyi.channel.plugin.android.model.wrapper.PackageWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.PluginWrapper;
import com.zoyi.channel.plugin.android.network.ChannelApi;
import com.zoyi.channel.plugin.android.network.RestSubscriber;
import com.zoyi.channel.plugin.android.network.ServiceFactory;
import com.zoyi.channel.plugin.android.socket.SocketManager;
import com.zoyi.channel.plugin.android.util.IntentUtils;
import com.zoyi.channel.plugin.android.util.L;
import com.zoyi.channel.plugin.android.util.RequestUtils;
import com.zoyi.retrofit2.okhttp3.RequestBody;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.android.AndroidSchedulers;
import com.zoyi.rx.schedulers.Schedulers;
import java.util.HashMap;
import java.util.concurrent.RejectedExecutionException;

public class ChannelPlugin {
    static Application application;
    static String pluginId;
    static ChannelApi service;
    static ActivityLifecycleManager lifecycleManager;
    static Thread.UncaughtExceptionHandler mUncaughtExceptionHandler;
    static Plugin plugin;
    static boolean checkInProcess;
    static boolean checkedIn;

    public static void initialize(Application application, String pluginId) {
        if (ChannelPlugin.application == null && ChannelPlugin.pluginId == null) {
            if (application == null) {
                L.e("Application cannot be null");
                return;
            }
            if (pluginId == null) {
                L.e("Plugin key cannot be null");
                return;
            }
            ChannelPlugin.application = application;
            ChannelPlugin.pluginId = pluginId;
            lifecycleManager = new ActivityLifecycleManager();
            ChannelPlugin.application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)lifecycleManager);
            SocketManager.init();
            mUncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
            Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread thread, Throwable ex) {
                    if (Looper.getMainLooper().getThread() == thread) {
                        mUncaughtExceptionHandler.uncaughtException(thread, ex);
                    } else if (ex instanceof RejectedExecutionException) {
                        SocketManager.reconnect();
                    }
                }
            });
            ChannelStore.veilId = PrefSupervisor.getVeilId(application);
        }
    }

    public static void checkIn() {
        ChannelPlugin.checkIn(null);
    }

    public static void checkIn(final CheckIn checkIn) {
        if (checkInProcess) {
            return;
        }
        if (application == null || pluginId == null) {
            L.e("Please initialize first");
            return;
        }
        ChannelPlugin.checkOut();
        checkInProcess = true;
        ChannelPlugin.getService().getLastestPackage("com.zoyi.channel.plugin.android", "0.0.1").subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new RestSubscriber<PackageWrapper>(){

            @Override
            public void onError(Throwable error) {
                L.e(error.getMessage());
            }

            @Override
            public void onNext(PackageWrapper wrapper) {
                if (!wrapper.isNeedToUpgrade()) {
                    ChannelPlugin.init(checkIn);
                } else {
                    L.e("Need to upgrade");
                }
            }
        });
    }

    private static void init(CheckIn checkIn) {
        HashMap<String, Object> form = new HashMap<String, Object>();
        if (checkIn != null) {
            form.put("name", checkIn.getName());
            form.put("mobileNumber", checkIn.getMobileNumber());
            form.put("avatarUrl", checkIn.getAvatarUrl());
            form.put("meta", checkIn.getMeta());
        }
        RequestBody body = RequestUtils.form(form).create();
        HashMap<String, String> headers = new HashMap<String, String>();
        if (checkIn != null && checkIn.getUserId() != null) {
            headers.put("X-User-Id", checkIn.getUserId());
        }
        if (PrefSupervisor.getVeilId(application) != null) {
            headers.put("X-Veil-Id", PrefSupervisor.getVeilId(application));
        }
        ChannelPlugin.getService().checkIn(headers, pluginId, body).subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new RestSubscriber<PluginWrapper>(){

            @Override
            public void onError(Throwable e) {
                L.e(e.getMessage());
                checkInProcess = false;
            }

            @Override
            public void onNext(PluginWrapper pluginWrapper) {
                PrefSupervisor.setVeilId(application, pluginWrapper.getVeilId());
                plugin = pluginWrapper.getPlugin();
                if (pluginWrapper.getUser() != null) {
                    ChannelStore.user = pluginWrapper.getUser();
                }
                ChannelStore.veil = pluginWrapper.getVeil();
                ChannelStore.veilId = pluginWrapper.getVeilId();
                ChannelStore.channel = pluginWrapper.getChannel();
                checkedIn = true;
                checkInProcess = false;
                SocketManager.setChannelId(pluginWrapper.getChannel().getId());
                SocketManager.connect();
                RxBus.post(new CommandBus(Command.CHECKED_IN, pluginWrapper.getPlugin()));
                ChannelStore.startFetchPlugin();
                ChannelStore.fetchScripts();
            }
        });
    }

    public static void checkOut() {
        checkedIn = false;
        ChannelStore.stopFetchPlugin();
        RxBus.post(new CommandBus(Command.CHECKED_OUT));
        SocketManager.setChannelId(null);
        SocketManager.disconnect();
        ChannelStore.user = null;
    }

    public static void launch(Context context) {
        if (!checkedIn) {
            L.e("Please ch_plugin_check in first");
            return;
        }
        if (context != null) {
            IntentUtils.setNextActivity(context, UserChatListActivity.class).startActivity();
        }
    }

    public static Application getApplication() {
        return application;
    }

    public static ChannelApi getService() {
        if (service == null) {
            service = ServiceFactory.create();
        }
        return service;
    }

    public static Plugin getPlugin() {
        if (checkedIn && plugin != null) {
            return plugin;
        }
        return null;
    }

    public static String getPluginId() {
        return pluginId;
    }

    static {
        checkInProcess = false;
        checkedIn = false;
    }
}

