/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.youtube.ui.views;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.SeekBar;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import androidx.core.graphics.drawable.DrawableCompat;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.view.youtube.player.PlayerConstants;
import com.zoyi.channel.plugin.android.view.youtube.player.YouTubePlayer;
import com.zoyi.channel.plugin.android.view.youtube.player.listener.YouTubePlayerListener;
import com.zoyi.channel.plugin.android.view.youtube.ui.utils.TimeUtilities;
import com.zoyi.com.annimon.stream.Optional;

public class CHYouTubePlayerSeekBar
extends LinearLayout
implements SeekBar.OnSeekBarChangeListener,
YouTubePlayerListener {
    private boolean seekBarTouchStarted = false;
    private int newSeekBarProgress = -1;
    private boolean isPlaying = false;
    private boolean showBufferingProgress = true;
    @Nullable
    private YouTubePlayerSeekBarListener youtubePlayerSeekBarListener;
    private TextView videoCurrentTimeTextView;
    private TextView videoDurationTextView;
    private SeekBar seekBar;

    public CHYouTubePlayerSeekBar(Context context) {
        super(context);
        this.init(context, null);
    }

    public CHYouTubePlayerSeekBar(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public void setYoutubePlayerSeekBarListener(@Nullable YouTubePlayerSeekBarListener youtubePlayerSeekBarListener) {
        this.youtubePlayerSeekBarListener = youtubePlayerSeekBarListener;
    }

    @Initializer
    public void init(Context context, @Nullable AttributeSet attrs) {
        this.videoCurrentTimeTextView = new TextView(context);
        this.videoDurationTextView = new TextView(context);
        this.seekBar = new SeekBar(context);
        int fontSize = this.getResources().getDimensionPixelSize(R.dimen.ch_ayp_12sp);
        int color2 = ContextCompat.getColor((Context)context, (int)R.color.ch_ayp_red);
        if (attrs != null) {
            TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.ChYouTubePlayerSeekBar, 0, 0);
            fontSize = typedArray.getDimensionPixelSize(R.styleable.ChYouTubePlayerSeekBar_ch_fontSize, fontSize);
            color2 = typedArray.getColor(R.styleable.ChYouTubePlayerSeekBar_ch_color, color2);
            typedArray.recycle();
        }
        int padding = this.getResources().getDimensionPixelSize(R.dimen.ch_ayp_8dp);
        this.videoCurrentTimeTextView.setText((CharSequence)this.getResources().getString(R.string.ch_ayp_null_time));
        this.videoCurrentTimeTextView.setPadding(padding, padding, 0, padding);
        this.videoCurrentTimeTextView.setTextColor(ContextCompat.getColor((Context)context, (int)17170443));
        this.videoCurrentTimeTextView.setGravity(16);
        this.videoDurationTextView.setText((CharSequence)this.getResources().getString(R.string.ch_ayp_null_time));
        this.videoDurationTextView.setPadding(0, padding, padding, padding);
        this.videoDurationTextView.setTextColor(ContextCompat.getColor((Context)context, (int)17170443));
        this.videoDurationTextView.setGravity(16);
        this.setFontSize(fontSize);
        this.seekBar.setPadding(padding * 2, padding, padding * 2, padding);
        this.setColor(color2);
        this.addView((View)this.videoCurrentTimeTextView, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
        this.addView((View)this.seekBar, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, -2, 1.0f));
        this.addView((View)this.videoDurationTextView, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
        this.setGravity(16);
        this.seekBar.setOnSeekBarChangeListener((SeekBar.OnSeekBarChangeListener)this);
    }

    public TextView getVideoDurationTextView() {
        return this.videoDurationTextView;
    }

    public SeekBar getSeekBar() {
        return this.seekBar;
    }

    public void setShowBufferingProgress(boolean showBufferingProgress) {
        this.showBufferingProgress = showBufferingProgress;
    }

    public void setFontSize(float fontSize) {
        this.videoCurrentTimeTextView.setTextSize(0, fontSize);
        this.videoDurationTextView.setTextSize(0, fontSize);
    }

    public void setColor(@ColorInt int color2) {
        DrawableCompat.setTint((Drawable)this.seekBar.getProgressDrawable(), (int)color2);
    }

    private void updateState(PlayerConstants.PlayerState state) {
        switch (state) {
            case ENDED: 
            case PAUSED: {
                this.isPlaying = false;
                break;
            }
            case PLAYING: {
                this.isPlaying = true;
                break;
            }
            case UNSTARTED: {
                this.resetUi();
                break;
            }
        }
    }

    private void resetUi() {
        this.seekBar.setProgress(0);
        this.seekBar.setMax(0);
        this.videoDurationTextView.post(() -> this.videoDurationTextView.setText((CharSequence)""));
    }

    public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
        this.videoCurrentTimeTextView.setText((CharSequence)TimeUtilities.formatTime(progress));
    }

    public void onStartTrackingTouch(SeekBar seekBar) {
        this.seekBarTouchStarted = true;
    }

    public void onStopTrackingTouch(SeekBar seekBar) {
        if (this.isPlaying) {
            this.newSeekBarProgress = seekBar.getProgress();
        }
        ((YouTubePlayerSeekBarListener)Optional.ofNullable((Object)this.youtubePlayerSeekBarListener).get()).seekTo(seekBar.getProgress());
        this.seekBarTouchStarted = false;
    }

    @Override
    public void onStateChange(YouTubePlayer youTubePlayer, PlayerConstants.PlayerState state) {
        this.newSeekBarProgress = -1;
        this.updateState(state);
    }

    @Override
    public void onCurrentSecond(YouTubePlayer youTubePlayer, float second) {
        if (this.seekBarTouchStarted) {
            return;
        }
        if (this.newSeekBarProgress > 0 && !TimeUtilities.formatTime(second).equals(TimeUtilities.formatTime(this.newSeekBarProgress))) {
            return;
        }
        this.newSeekBarProgress = -1;
        this.seekBar.setProgress((int)second);
    }

    @Override
    public void onVideoDuration(YouTubePlayer youTubePlayer, float duration) {
        this.videoDurationTextView.setText((CharSequence)TimeUtilities.formatTime(duration));
        this.seekBar.setMax((int)duration);
    }

    @Override
    public void onVideoLoadedFraction(YouTubePlayer youTubePlayer, float loadedFraction) {
        this.seekBar.setSecondaryProgress(this.showBufferingProgress ? (int)(loadedFraction * (float)this.seekBar.getMax()) : 0);
    }

    @Override
    public void onReady(YouTubePlayer youTubePlayer) {
    }

    @Override
    public void onPlaybackQualityChange(YouTubePlayer youTubePlayer, PlayerConstants.PlaybackQuality playbackQuality) {
    }

    @Override
    public void onPlaybackRateChange(YouTubePlayer youTubePlayer, PlayerConstants.PlaybackRate playbackRate) {
    }

    @Override
    public void onError(YouTubePlayer youTubePlayer, PlayerConstants.PlayerError error) {
    }

    @Override
    public void onVideoId(YouTubePlayer youTubePlayer, String videoId) {
    }

    @Override
    public void onApiChange(YouTubePlayer youTubePlayer) {
    }

    public static interface YouTubePlayerSeekBarListener {
        public void seekTo(float var1);
    }
}

