/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.video_player;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.view.video_player.AbsVideoPlayerView;
import com.zoyi.channel.plugin.android.view.youtube.player.PlayerConstants;
import com.zoyi.channel.plugin.android.view.youtube.player.YouTubePlayer;
import com.zoyi.channel.plugin.android.view.youtube.player.listener.AbstractYouTubePlayerListener;
import com.zoyi.channel.plugin.android.view.youtube.player.views.CHYouTubePlayerView;

public class YouTubeVideoPlayerView
extends AbsVideoPlayerView {
    @Nullable
    private CHYouTubePlayerView playerYouTube;
    @Nullable
    private YouTubePlayer youTubePlayer;

    public YouTubeVideoPlayerView(@NonNull Context context) {
        super(context);
        this.init(context);
    }

    public YouTubeVideoPlayerView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public YouTubeVideoPlayerView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    private void init(Context context) {
        LayoutInflater.from((Context)context).inflate(R.layout.ch_view_youtube_video_player, (ViewGroup)this);
        this.playerYouTube = (CHYouTubePlayerView)this.findViewById(R.id.ch_playerYouTube);
    }

    public void setVideoId(@Nullable String messageId, @Nullable String webPageId, String videoId) {
        this.setId(String.format("%s:%s:%s", messageId, webPageId, videoId));
        if (this.playerYouTube != null) {
            this.playerYouTube.getYouTubePlayerWhenReady(youTubePlayer -> {
                this.youTubePlayer = youTubePlayer;
                youTubePlayer.mute();
                youTubePlayer.loadVideo(videoId, this.getLatestSeconds());
            });
            this.playerYouTube.addYouTubePlayerListener(new AbstractYouTubePlayerListener(){

                @Override
                public void onStateChange(YouTubePlayer youTubePlayer, PlayerConstants.PlayerState state) {
                    YouTubeVideoPlayerView.this.changeVideoState(state == PlayerConstants.PlayerState.PLAYING || state == PlayerConstants.PlayerState.BUFFERING);
                }

                @Override
                public void onCurrentSecond(YouTubePlayer youTubePlayer, float second) {
                    try {
                        YouTubeVideoPlayerView.this.changeVideoPosition((long)second);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
    }

    @Override
    void onVideoPaused() {
        if (this.youTubePlayer != null) {
            this.youTubePlayer.pause();
        }
    }

    @Override
    public void clear() {
        super.clear();
        if (this.playerYouTube != null) {
            this.playerYouTube.release();
        }
    }
}

