/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.video_player;

import android.content.Context;
import android.net.Uri;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.model.rest.media.instagram.InstagramMediaEntity;
import com.zoyi.channel.plugin.android.store.GlobalStore;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.view.video_player.AbsVideoPlayerView;
import com.zoyi.com.google.android.exoplayer2.DefaultRenderersFactory;
import com.zoyi.com.google.android.exoplayer2.ExoPlayerFactory;
import com.zoyi.com.google.android.exoplayer2.Player;
import com.zoyi.com.google.android.exoplayer2.RenderersFactory;
import com.zoyi.com.google.android.exoplayer2.SimpleExoPlayer;
import com.zoyi.com.google.android.exoplayer2.source.ExtractorMediaSource;
import com.zoyi.com.google.android.exoplayer2.source.MediaSource;
import com.zoyi.com.google.android.exoplayer2.trackselection.AdaptiveTrackSelection;
import com.zoyi.com.google.android.exoplayer2.trackselection.DefaultTrackSelector;
import com.zoyi.com.google.android.exoplayer2.trackselection.TrackSelection;
import com.zoyi.com.google.android.exoplayer2.trackselection.TrackSelector;
import com.zoyi.com.google.android.exoplayer2.ui.PlayerView;
import com.zoyi.com.google.android.exoplayer2.upstream.DataSource;
import com.zoyi.com.google.android.exoplayer2.upstream.DefaultHttpDataSourceFactory;
import com.zoyi.com.google.android.exoplayer2.util.Util;
import java.util.concurrent.TimeUnit;

public class InstagramVideoView
extends AbsVideoPlayerView {
    private Context context;
    private PlayerView player;
    @Nullable
    private SimpleExoPlayer exoPlayer;

    public InstagramVideoView(@NonNull Context context) {
        super(context);
        this.init(context);
    }

    public InstagramVideoView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public InstagramVideoView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    @Initializer
    private void init(Context context) {
        this.context = context;
        LayoutInflater.from((Context)context).inflate(R.layout.ch_view_instagram_video_view, (ViewGroup)this);
        this.player = (PlayerView)this.findViewById(R.id.ch_playerInstagram);
    }

    public InstagramVideoView setData(InstagramMediaEntity data, boolean isVolumeOn) {
        this.setId(data.getId());
        AdaptiveTrackSelection.Factory videoTrackSelectionFactory = new AdaptiveTrackSelection.Factory();
        DefaultTrackSelector trackSelector = new DefaultTrackSelector((TrackSelection.Factory)videoTrackSelectionFactory);
        this.exoPlayer = ExoPlayerFactory.newSimpleInstance((Context)this.context, (RenderersFactory)new DefaultRenderersFactory(this.context), (TrackSelector)trackSelector);
        this.exoPlayer.addListener(new Player.EventListener(){

            public void onPlayerStateChanged(boolean playWhenReady, int playbackState) {
                InstagramVideoView.this.changeVideoState(playWhenReady);
                switch (playbackState) {
                    case 4: {
                        if (InstagramVideoView.this.exoPlayer == null) break;
                        InstagramVideoView.this.exoPlayer.seekTo(0L);
                        InstagramVideoView.this.exoPlayer.setPlayWhenReady(true);
                    }
                }
            }
        });
        this.player.setPlayer((Player)this.exoPlayer);
        DefaultHttpDataSourceFactory dataSourceFactory = new DefaultHttpDataSourceFactory(Util.getUserAgent((Context)this.context, (String)"ChannelTalkSDK"));
        dataSourceFactory.getDefaultRequestProperties().set("x-session", GlobalStore.get().jwt.get());
        ExtractorMediaSource videoSource = new ExtractorMediaSource.Factory((DataSource.Factory)dataSourceFactory).createMediaSource(Uri.parse((String)data.getMediaUrl()));
        this.exoPlayer.prepare((MediaSource)videoSource);
        this.exoPlayer.setPlayWhenReady(false);
        this.exoPlayer.seekTo(this.getLatestSeconds() * TimeUnit.SECONDS.toMillis(1L));
        this.applyVolumeButton(isVolumeOn);
        return this;
    }

    public void applyVolumeButton(boolean isVolumeOn) {
        if (this.exoPlayer != null) {
            this.exoPlayer.setVolume(isVolumeOn ? 1.0f : 0.0f);
        }
        this.changeVideoVolumeState(isVolumeOn);
    }

    public void onActive() {
        if (this.exoPlayer != null) {
            this.exoPlayer.setPlayWhenReady(true);
        }
    }

    public void onDeactivate() {
        if (this.exoPlayer != null) {
            this.exoPlayer.setPlayWhenReady(false);
        }
    }

    @Override
    void onVideoPaused() {
        if (this.exoPlayer != null) {
            this.exoPlayer.setPlayWhenReady(false);
        }
    }

    @Override
    public void clear() {
        super.clear();
        if (this.exoPlayer != null) {
            this.exoPlayer.release();
            this.exoPlayer = null;
        }
    }
}

