/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.option;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.Views;

public class CheckView
extends FrameLayout {
    private TextView textView;
    private View imageView;

    public CheckView(@NonNull Context context) {
        super(context);
        this.init(context, null);
    }

    public CheckView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public CheckView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Initializer
    private void init(Context context, @Nullable AttributeSet attrs) {
        View root = LayoutInflater.from((Context)context).inflate(R.layout.ch_view_check, (ViewGroup)this, true);
        this.textView = (TextView)root.findViewById(R.id.ch_textCheckView);
        this.imageView = root.findViewById(R.id.ch_imageCheckViewCheck);
        if (attrs != null) {
            TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.CheckView);
            try {
                this.textView.setText((CharSequence)typedArray.getString(R.styleable.CheckView_ch_cv_text));
            }
            finally {
                typedArray.recycle();
            }
        }
        this.setChecked(false);
    }

    public void setChecked(boolean isChecked) {
        this.textView.setTextColor(ResUtils.getColor(isChecked ? R.color.ch_grey900 : R.color.ch_grey500));
        Views.setVisibility(this.imageView, isChecked);
    }
}

