/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.media_thumbnail;

import android.content.Context;
import android.graphics.Point;
import android.util.AttributeSet;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.zoyi.channel.plugin.android.activity.chat.listener.contentview.OnAttachmentContentActionListener;
import com.zoyi.channel.plugin.android.model.rest.File;
import com.zoyi.channel.plugin.android.util.CalculationUtils;
import com.zoyi.channel.plugin.android.util.draw.Display;
import com.zoyi.channel.plugin.android.view.media_thumbnail.AttachmentMediaThumbnailView;

public class SquareAttachmentMediaThumbnailView
extends AttachmentMediaThumbnailView {
    private Context context;

    public SquareAttachmentMediaThumbnailView(@NonNull Context context) {
        super(context);
        this.init(context);
    }

    public SquareAttachmentMediaThumbnailView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public SquareAttachmentMediaThumbnailView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    private void init(Context context) {
        this.context = context;
    }

    @Override
    public void setAttachment(@Nullable String messageId, File attachment, @Nullable OnAttachmentContentActionListener listener) {
        super.setAttachment(messageId, attachment, listener);
        int screenWidth = Display.getWidth(this.context);
        int imageWidth = Math.max(attachment.getWidth(), 1);
        int imageHeight = Math.max(attachment.getHeight(), 1);
        int size = CalculationUtils.min(screenWidth / 2, imageWidth, imageHeight);
        this.setImage(attachment.getThumbnailURL(new Point(size, size)));
    }
}

