/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.media_thumbnail;

import android.content.Context;
import android.graphics.Point;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.listener.contentview.OnAttachmentContentActionListener;
import com.zoyi.channel.plugin.android.model.rest.File;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.draw.Display;
import com.zoyi.channel.plugin.android.view.media_thumbnail.AttachmentMediaThumbnailView;

public class OriginAttachmentMediaThumbnailView
extends AttachmentMediaThumbnailView {
    private Context context;
    private int resolvedWidth = 0;
    private int resolvedHeight = 0;
    private int minWidth;
    private int minHeight;
    private int maxHeight;

    public OriginAttachmentMediaThumbnailView(@NonNull Context context) {
        super(context);
        this.init(context);
    }

    public OriginAttachmentMediaThumbnailView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public OriginAttachmentMediaThumbnailView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    private void init(Context context) {
        this.context = context;
        this.minWidth = ResUtils.getDimen(context, R.dimen.ch_chat_message_attachments_min_size);
        this.minHeight = ResUtils.getDimen(context, R.dimen.ch_chat_message_attachments_min_size);
        this.maxHeight = Display.getHeight(context) / 2;
    }

    @Override
    public void setAttachment(@Nullable String messageId, File attachment, @Nullable OnAttachmentContentActionListener listener) {
        super.setAttachment(messageId, attachment, listener);
        int screenWidth = Display.getWidth(this.context);
        int imageWidth = Math.max(attachment.getWidth(), 1);
        int imageHeight = Math.max(attachment.getHeight(), 1);
        this.resolvedWidth = Math.min(imageWidth, screenWidth);
        this.resolvedHeight = Math.min(imageHeight, Math.max(1, imageHeight * screenWidth / imageWidth));
        this.setImage(attachment.getThumbnailURL(new Point(this.resolvedWidth, this.resolvedHeight)), ImageView.ScaleType.FIT_CENTER);
        this.requestLayout();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int measuredWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int viewWidth = this.resolvedWidth;
        int viewHeight = this.resolvedHeight;
        if (this.resolvedWidth > measuredWidth && this.resolvedHeight > this.maxHeight) {
            float resolvedRatio = Math.max((float)this.resolvedWidth / (float)measuredWidth, (float)this.resolvedHeight / (float)this.maxHeight);
            viewWidth = (int)((float)this.resolvedWidth / resolvedRatio);
            viewHeight = (int)((float)this.resolvedHeight / resolvedRatio);
        } else if (this.resolvedWidth > measuredWidth) {
            viewWidth = measuredWidth;
            viewHeight = this.resolvedHeight * measuredWidth / this.resolvedWidth;
        } else if (this.resolvedHeight > this.maxHeight) {
            viewWidth = measuredWidth * this.maxHeight / this.resolvedHeight;
            viewHeight = this.maxHeight;
        }
        super.onMeasure(View.MeasureSpec.makeMeasureSpec((int)Math.max(viewWidth, this.minWidth), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)Math.max(viewHeight, this.minHeight), (int)0x40000000));
    }
}

