/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.button;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.enumerate.ButtonTheme;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.view.layout.ChBorderLayout;

public abstract class LinkButton
extends FrameLayout {
    public String text = "";
    public int textColor = R.color.ch_grey900;
    public int backColor = R.color.ch_black_5;
    private ChBorderLayout layoutLinkButton;
    private TextView textLinkButton;

    public LinkButton(@NonNull Context context) {
        super(context);
        this.init(context);
    }

    public LinkButton(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public LinkButton(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    @Initializer
    private void init(Context context) {
        View view = LayoutInflater.from((Context)context).inflate(R.layout.ch_view_link_button, (ViewGroup)this, true);
        this.layoutLinkButton = (ChBorderLayout)view.findViewById(R.id.ch_layoutLinkButton);
        this.textLinkButton = (TextView)view.findViewById(R.id.ch_textLinkButton);
    }

    public void initMessageLinkButton() {
        this.setText("");
        this.setTextColor(ResUtils.getColor(R.color.ch_grey900));
    }

    public void initPopupLinkButton() {
        this.setBackColor(ResUtils.getColor(R.color.ch_black_5));
        this.setText("");
        this.setTextColor(ResUtils.getColor(R.color.ch_grey900));
        this.setTypeface(0);
    }

    public void setText(String text) {
        this.text = text;
        if (this.textLinkButton != null) {
            this.textLinkButton.setText((CharSequence)text);
        }
    }

    public void setMessageTheme(ButtonTheme buttonTheme) {
        if (buttonTheme != ButtonTheme.UNKNOWN) {
            this.setTextColor(ResUtils.getColor(buttonTheme.getColor()));
        }
    }

    public void setPopupTheme(ButtonTheme buttonTheme) {
        if (buttonTheme != ButtonTheme.UNKNOWN) {
            this.setBackColor(ResUtils.getColor(buttonTheme.getColor()));
            this.setTextColor(-1);
            this.setTypeface(1);
        }
    }

    private void setBorderWidth(float width) {
        if (this.layoutLinkButton != null) {
            this.layoutLinkButton.setBorderWidth(width);
        }
    }

    private void setBorderColor(int color2) {
        if (this.layoutLinkButton != null) {
            this.layoutLinkButton.setBorderColor(color2);
        }
    }

    private void setTextColor(int textColor) {
        this.textColor = textColor;
        if (this.textLinkButton != null) {
            this.textLinkButton.setTextColor(textColor);
        }
    }

    private void setBackColor(int backColor) {
        this.backColor = backColor;
        if (this.layoutLinkButton != null) {
            this.layoutLinkButton.setBackColor(backColor);
        }
    }

    private void setTypeface(int typeface) {
        if (this.textLinkButton != null) {
            this.textLinkButton.setTypeface(this.textLinkButton.getTypeface(), typeface);
        }
    }
}

