/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.util;

import androidx.annotation.DrawableRes;
import androidx.annotation.Nullable;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.model.rest.Channel;
import com.zoyi.channel.plugin.android.model.rest.Plugin;
import com.zoyi.channel.plugin.android.util.ResUtils;

public class ComponentUtils {
    @Nullable
    public static String getResponseKey(@Nullable Channel channel, Boolean isWorking) {
        if (channel == null || channel.getExpectedResponseDelay() == null || isWorking == null) {
            return null;
        }
        if (!isWorking.booleanValue()) {
            return "ch.chat.expect_response_delay.out_of_working";
        }
        switch (channel.getExpectedResponseDelay()) {
            case "instant": {
                return "ch.chat.expect_response_delay.instant";
            }
            case "normal": {
                return "ch.chat.expect_response_delay.normal";
            }
            case "delayed": {
                return "ch.chat.expect_response_delay.delayed";
            }
        }
        return null;
    }

    @Nullable
    public static String getShortResponseDescription(@Nullable Channel channel, @Nullable Integer remainMinutes) {
        if (channel == null || channel.getExpectedResponseDelay() == null || remainMinutes == null) {
            return null;
        }
        if (remainMinutes > 0) {
            if (remainMinutes >= 60) {
                return String.format(ResUtils.getString("ch.navigation.next_operation.hour_left"), remainMinutes / 60);
            }
            return String.format(ResUtils.getString("ch.navigation.next_operation.minutes_left"), remainMinutes);
        }
        if (remainMinutes < 0) {
            return ResUtils.getString("ch.chat.expect_response_delay.out_of_working.short_description");
        }
        switch (channel.getExpectedResponseDelay()) {
            case "instant": {
                return ResUtils.getString("ch.chat.expect_response_delay.instant.short_description");
            }
            case "normal": {
                return ResUtils.getString("ch.chat.expect_response_delay.normal.short_description");
            }
            case "delayed": {
                return ResUtils.getString("ch.chat.expect_response_delay.delayed.short_description");
            }
        }
        return null;
    }

    @DrawableRes
    public static int getResponseSymbol(@Nullable Plugin plugin, @Nullable Channel channel, Boolean isWorking) {
        if (plugin == null || channel == null || isWorking == null) {
            return 0;
        }
        int textColor = plugin.getTextColor();
        if (!isWorking.booleanValue()) {
            return textColor == -1 ? R.drawable.ch_plugin_offhours_w : R.drawable.ch_plugin_offhours_b;
        }
        if (channel.getExpectedResponseDelay() == null) {
            return 0;
        }
        switch (channel.getExpectedResponseDelay()) {
            case "instant": {
                return textColor == -1 ? R.drawable.ch_plugin_fast_w : R.drawable.ch_plugin_fast_b;
            }
            case "normal": {
                return textColor == -1 ? R.drawable.ch_plugin_normal_w : R.drawable.ch_plugin_normal_b;
            }
            case "delayed": {
                return textColor == -1 ? R.drawable.ch_plugin_delayed_w : R.drawable.ch_plugin_delayed_b;
            }
        }
        return 0;
    }
}

