/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.util;

import androidx.annotation.Nullable;

public class CompareUtils {
    public static boolean equals(@Nullable String s1, @Nullable String s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        return s1.equals(s2);
    }

    public static boolean isSame(String s1, String s2) {
        return CompareUtils.compare(s1, s2) == 0;
    }

    public static int compare(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return 0;
        }
        if (s1 == null) {
            return 1;
        }
        if (s2 == null) {
            return -1;
        }
        return s1.compareTo(s2);
    }

    public static int compare(Long lhs, Long rhs) {
        if (lhs == null && rhs == null) {
            return 0;
        }
        if (lhs == null) {
            return -1;
        }
        if (rhs == null) {
            return 1;
        }
        return Long.compare(lhs, rhs);
    }

    @SafeVarargs
    public static <E extends Comparable> boolean exists(E target, E ... values) {
        for (E ee : values) {
            if (!(ee == null ? target == null : ee.equals(target))) continue;
            return true;
        }
        return false;
    }

    private static int asciiCase(char ch) {
        return ch < '\u0080' ? 1 : 0;
    }

    private static char foldCase(char ch) {
        if (ch < '\u0080') {
            if ('A' <= ch && ch <= 'Z') {
                return (char)(ch + 32);
            }
            return ch;
        }
        return Character.toLowerCase(Character.toUpperCase(ch));
    }
}

