/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.store.state;

import androidx.annotation.Nullable;
import com.zoyi.channel.plugin.android.store.callback.StateCallback;
import com.zoyi.channel.plugin.android.store.state.BaseState;
import java.util.concurrent.atomic.AtomicReference;

public class State<E>
extends BaseState<E> {
    private AtomicReference<E> data;
    protected E defaultData;
    private StateCallback<E> callback;

    public State() {
        this.defaultData = null;
        this.callback = null;
        this.data = new AtomicReference<Object>(null);
    }

    public State(E data) {
        this.defaultData = data;
        this.callback = null;
        this.data = new AtomicReference<E>(data);
    }

    public State(StateCallback<E> callback) {
        this.defaultData = null;
        this.callback = callback;
        this.data = new AtomicReference<Object>(null);
    }

    public State(E data, StateCallback<E> callback) {
        this.defaultData = data;
        this.callback = callback;
        this.data = new AtomicReference<E>(data);
    }

    public void set(E data) {
        this.set(data, true);
    }

    public void set(E data, boolean notify) {
        if (this.callback == null || this.callback.updated(this.data.get(), data)) {
            this.data.set(data);
            if (notify) {
                this.post();
            }
        }
    }

    @Override
    @Nullable
    public E get() {
        return this.data.get();
    }

    @Override
    public void reset() {
        this.set(this.defaultData);
    }
}

