/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.store.state;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.zoyi.channel.plugin.android.store.callback.MapStateCallback;
import com.zoyi.channel.plugin.android.store.state.BaseState;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class MapState<K, V>
extends BaseState<Map<K, V>> {
    private ConcurrentHashMap<K, V> map;
    private MapStateCallback<K, V> callback;

    public MapState(MapStateCallback<K, V> callback) {
        this.callback = callback;
        this.map = new ConcurrentHashMap();
    }

    public void set(Collection<V> collection) {
        if (collection != null) {
            Set oldKeySet = this.map.keySet();
            for (V value : collection) {
                K key = this.callback.getKey(value);
                if (key == null) continue;
                oldKeySet.remove(key);
            }
            for (Object key : oldKeySet) {
                this.map.remove(key);
            }
            this.addOperation(collection, true);
            this.post();
        }
    }

    public void add(Collection<V> collection) {
        if (collection != null) {
            this.addOperation(collection, false);
            this.post();
        }
    }

    private void addOperation(Collection<V> collection, boolean set) {
        HashMap<K, V> addMap = new HashMap<K, V>();
        for (V value : collection) {
            V oldbie;
            K key = this.callback.getKey(value);
            if (key == null || (oldbie = this.get(key)) != null && !set && !this.canUpdate(oldbie, value)) continue;
            addMap.put(key, value);
        }
        this.map.putAll(addMap);
    }

    public boolean upsert(V value) {
        if (value != null) {
            K key = this.callback.getKey(value);
            V oldbie = this.get(key);
            if (key != null && (oldbie == null || this.canUpdate(oldbie, value))) {
                this.map.put(key, value);
                this.post();
                return true;
            }
        }
        return false;
    }

    public V remove(V value) {
        K key;
        if (value != null && (key = this.callback.getKey(value)) != null) {
            V removedValue = this.map.remove(this.callback.getKey(value));
            this.post();
            return removedValue;
        }
        return null;
    }

    public void removeByKey(K key) {
        V value;
        if (key != null && (value = this.map.remove(key)) != null) {
            this.post();
        }
    }

    public void clear() {
        this.map.clear();
        this.post();
    }

    @Override
    @NonNull
    public Map<K, V> get() {
        return this.map;
    }

    @Nullable
    public V get(K key) {
        if (key != null && this.map.containsKey(key)) {
            return this.map.get(key);
        }
        return null;
    }

    @Override
    public void reset() {
        this.map.clear();
    }

    protected boolean canUpdate(V oldbie, V newbie) {
        return true;
    }
}

