/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.selector;

import androidx.annotation.Nullable;
import com.zoyi.channel.plugin.android.bind.Binder;
import com.zoyi.channel.plugin.android.model.entity.ProfileEntity;
import com.zoyi.channel.plugin.android.model.etc.PushEvent;
import com.zoyi.channel.plugin.android.model.rest.Channel;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.model.rest.Plugin;
import com.zoyi.channel.plugin.android.model.rest.User;
import com.zoyi.channel.plugin.android.open.model.PopupData;
import com.zoyi.channel.plugin.android.selector.ProfileSelector;
import com.zoyi.channel.plugin.android.store.ChannelStore;
import com.zoyi.channel.plugin.android.store.GlobalStore;
import com.zoyi.channel.plugin.android.store.PluginStore;
import com.zoyi.channel.plugin.android.store.PopupStore;
import com.zoyi.channel.plugin.android.store.SettingsStore;
import com.zoyi.channel.plugin.android.store.TimerStore;
import com.zoyi.channel.plugin.android.store.UserStore;
import com.zoyi.channel.plugin.android.store.binder.Binder1;
import com.zoyi.channel.plugin.android.store.binder.Binder2;
import com.zoyi.channel.plugin.android.store.binder.Binder3;
import com.zoyi.channel.plugin.android.store.state.BooleanState;
import com.zoyi.channel.plugin.android.store.state.State;
import com.zoyi.channel.plugin.android.util.ChannelUtils;
import com.zoyi.com.annimon.stream.Optional;
import com.zoyi.rx.functions.Action1;
import com.zoyi.rx.functions.Action2;
import com.zoyi.rx.functions.Action3;

public class GlobalSelector {
    public static Binder bindBootState(Action1<Boolean> action1) {
        return new Binder1<Boolean>(GlobalStore.get().bootState).bind((Action1<Boolean>)((Action1)arg_0 -> action1.call(arg_0)));
    }

    public static Binder bindMessengerVisibility(Action1<Boolean> action1) {
        return new Binder1<Boolean>(GlobalStore.get().messengerState).bind(action1);
    }

    public static Binder bindLauncherVisibility(Action1<Boolean> action1) {
        BooleanState bootState = GlobalStore.get().bootState;
        BooleanState showLauncherState = SettingsStore.get().showLauncher;
        return new Binder2<Boolean, Boolean>(bootState, showLauncherState).bind((Action2<Boolean, Boolean>)((Action2)(isBooted, showLauncher) -> action1.call((Object)(isBooted != false && showLauncher != false ? 1 : 0))));
    }

    private static boolean getLauncherVisibility(boolean showLauncher, Channel channel, Long now) {
        if (!showLauncher || now == null || channel == null) {
            return false;
        }
        return ChannelUtils.isWorking(channel, now) || !"hidden".equals(channel.getAwayOption());
    }

    public static boolean getLauncherVisibility() {
        return GlobalSelector.getLauncherVisibility(SettingsStore.get().showLauncher.get(), ChannelStore.get().channelState.get(), TimerStore.get().now.get());
    }

    public static Binder bindPopup(Action1<PopupData> action1) {
        State<Message> popupMessageState = PopupStore.get().popupMessage;
        return new Binder1<Message>(popupMessageState).bind((Action1<Message>)((Action1)message -> {
            ProfileEntity profile;
            if (message != null && (profile = ProfileSelector.getProfile(message.getPersonType(), message.getPersonId())) != null) {
                action1.call((Object)new PopupData((Message)message, profile));
            }
        }));
    }

    public static Binder bindLegacyInAppPush(Action1<PushEvent> action1) {
        State<Message> inAppPushMessageState = PopupStore.get().popupMessage;
        return new Binder1<Message>(inAppPushMessageState).bind((Action1<Message>)((Action1)message -> {
            ProfileEntity profile;
            if (message != null && (profile = ProfileSelector.getProfile(message.getPersonType(), message.getPersonId())) != null) {
                action1.call((Object)new PushEvent((Message)message, profile));
            }
        }));
    }

    public static Binder bindLauncherStyle(Action3<Plugin, Integer, Boolean> action3) {
        State<Plugin> pluginState = PluginStore.get().pluginState;
        State<Message> popupMessageState = PopupStore.get().popupMessage;
        State<User> userState = UserStore.get().user;
        return new Binder3<Plugin, Message, User>(pluginState, popupMessageState, userState).bind((Action3<Plugin, Message, User>)((Action3)(plugin, popupMessage, user) -> {
            if (plugin != null) {
                int count = user != null ? user.getAlert() : 0;
                boolean isMarketingVisible = popupMessage != null && popupMessage.getMarketing() != null;
                action3.call(plugin, (Object)count, (Object)isMarketingVisible);
            }
        }));
    }

    @Nullable
    public static String getTopActivityName() {
        return (String)Optional.ofNullable((Object)GlobalStore.get().topActivity.get()).map(activity -> activity.getClass().getSimpleName()).orElse(null);
    }
}

