/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.push;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.app.NotificationCompat;
import androidx.core.app.NotificationManagerCompat;
import com.zoyi.channel.plugin.android.enumerate.ActionType;
import com.zoyi.channel.plugin.android.global.Api;
import com.zoyi.channel.plugin.android.global.PrefSupervisor;
import com.zoyi.channel.plugin.android.model.repo.EmptyRepo;
import com.zoyi.channel.plugin.android.network.RestSubscriber;
import com.zoyi.channel.plugin.android.open.option.Language;
import com.zoyi.channel.plugin.android.push.NotificationFactory;
import com.zoyi.channel.plugin.android.push.PushData;
import com.zoyi.channel.plugin.android.store.SettingsStore;
import com.zoyi.channel.plugin.android.util.CompareUtils;
import com.zoyi.channel.plugin.android.util.DeviceUtils;
import com.zoyi.channel.plugin.android.util.ImageUtils;
import com.zoyi.channel.plugin.android.util.L;
import com.zoyi.channel.plugin.android.util.RequestUtils;
import com.zoyi.com.annimon.stream.Optional;
import com.zoyi.com.bumptech.glide.Glide;
import com.zoyi.okhttp3.RequestBody;
import com.zoyi.rx.android.schedulers.AndroidSchedulers;
import com.zoyi.rx.schedulers.Schedulers;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class ChannelPushManager {
    private static final int NOTIFICATION_ID = 0x3FFFFFFF;

    private static Bundle convertMessageMapToBundle(Map<String, String> message) {
        Bundle bundle = new Bundle();
        for (Map.Entry<String, String> entry : message.entrySet()) {
            bundle.putString(entry.getKey(), entry.getValue());
        }
        return bundle;
    }

    public static boolean isChannelPushNotification(Map<String, String> message) {
        return ChannelPushManager.isChannelPushNotification(ChannelPushManager.convertMessageMapToBundle(message));
    }

    public static boolean isChannelPushNotification(Bundle message) {
        if (message == null) {
            return false;
        }
        PushData pushData = new PushData(message);
        return pushData.isChannelPluginMessage();
    }

    public static void registerPushToken(final @Nullable Context context) {
        String jwt = PrefSupervisor.getJwt(context);
        if (context != null && jwt != null) {
            final String token = PrefSupervisor.getDeviceToken(context);
            String sentToken = PrefSupervisor.getSentDeviceToken(context);
            if (!TextUtils.isEmpty((CharSequence)token) && !CompareUtils.isSame(token, sentToken)) {
                RequestBody body = RequestUtils.form().set("key", String.format("android-%s", DeviceUtils.getDeviceId(context))).set("token", token).create();
                Api.sendToken(body, jwt).cancelBy(ActionType.SHUTDOWN).run(new RestSubscriber<EmptyRepo>(){

                    @Override
                    public void onSuccess(@NonNull EmptyRepo empty) {
                        PrefSupervisor.setSentDeviceToken(context, token);
                    }
                });
            }
        }
    }

    public static void deregisterPushToken(Context context) {
        String jwt = PrefSupervisor.getJwt(context);
        if (jwt != null) {
            Api.getApi().deleteToken(((Language)((Object)SettingsStore.get().language.get())).toString(), String.format("android-%s", DeviceUtils.getDeviceId(context)), jwt).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe(new RestSubscriber());
        }
        PrefSupervisor.setSentDeviceToken(context, null);
    }

    public static void receivePushNotification(Context context, Map<String, String> message) {
        ChannelPushManager.receivePushNotification(context, ChannelPushManager.convertMessageMapToBundle(message));
    }

    public static void receivePushNotification(Context context, Bundle message) {
        String personType = message.getString("personType");
        String personId = message.getString("personId");
        String chatId = message.getString("chatId");
        if ("user".equals(personType) && personId != null && chatId != null) {
            if (personId.equals(PrefSupervisor.getLatestBootedUserId(context))) {
                ChannelPushManager.sendNotification(context, message);
                ChannelPushManager.receivePushNotification(context, chatId);
            } else {
                Api.deleteToken(String.format("android-%s", DeviceUtils.getDeviceId(context)), personId).run();
            }
        }
    }

    private static void sendNotification(Context context, Bundle message) {
        PushData pushData = new PushData(message);
        NotificationCompat.Builder builder = NotificationFactory.createPushMessage(context, pushData);
        if (builder != null) {
            try {
                String avatarUrl = pushData.getAvatarUrl();
                if (avatarUrl == null) {
                    throw new Exception("avatar url is null");
                }
                Bitmap avatarBitmap = (Bitmap)Glide.with((Context)context).load(avatarUrl).asBitmap().into(Integer.MIN_VALUE, Integer.MIN_VALUE).get(3000L, TimeUnit.MILLISECONDS);
                if (avatarBitmap == null) {
                    throw new Exception("avatar bitmap is null");
                }
                builder.setLargeIcon(ImageUtils.getCircularBitmap(avatarBitmap));
            }
            catch (Exception ex) {
                L.e(ex.getMessage());
            }
            NotificationManagerCompat.from((Context)context).notify(0x3FFFFFFF, builder.build());
        }
    }

    private static void receivePushNotification(Context context, String chatId) {
        String jwt = (String)Optional.ofNullable((Object)context).map(PrefSupervisor::getJwt).orElse(null);
        if (jwt != null) {
            Api.getApi().receivePushNotification(chatId, jwt).onBackpressureBuffer().subscribeOn(Schedulers.io()).subscribe(new RestSubscriber());
        }
    }

    static void clearNotification(Context context) {
        try {
            NotificationManagerCompat.from((Context)context).cancel(0x3FFFFFFF);
        }
        catch (Exception ex) {
            L.e(ex.getMessage());
        }
    }
}

