/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.global;

import androidx.annotation.Nullable;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.OnLifecycleEvent;
import com.zoyi.channel.plugin.android.ChannelIO;
import com.zoyi.channel.plugin.android.socket.SocketManager;
import com.zoyi.channel.plugin.android.store.TimerStore;
import com.zoyi.channel.plugin.android.util.L;
import com.zoyi.channel.plugin.android.util.TimeUtils;
import com.zoyi.channel.plugin.android.util.draw.Display;
import com.zoyi.rx.Observable;
import com.zoyi.rx.Subscription;
import com.zoyi.rx.android.schedulers.AndroidSchedulers;
import com.zoyi.rx.schedulers.Schedulers;
import java.util.concurrent.TimeUnit;

public class LifecycleController
implements LifecycleObserver {
    private boolean isForeground = false;
    @Nullable
    private Subscription workingTimer;
    @Nullable
    private Subscription activeActionDelayHolder;

    @OnLifecycleEvent(value=Lifecycle.Event.ON_START)
    public void onStart() {
        L.d("Application on foreground");
        this.isForeground = true;
        if (ChannelIO.isBooted()) {
            this.doOnActivated();
        }
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_STOP)
    public void onStop() {
        L.d("Application on background");
        this.isForeground = false;
        this.doOnDeactivated();
    }

    public boolean isForeground() {
        return this.isForeground;
    }

    public void doOnActivated() {
        L.d("Do action on activated: Locked: " + Display.isLocked());
        if (!Display.isLocked()) {
            SocketManager.connect();
            this.attachTimestampTimer();
        } else if (this.activeActionDelayHolder == null || this.activeActionDelayHolder.isUnsubscribed()) {
            this.activeActionDelayHolder = Observable.timer((long)1000L, (TimeUnit)TimeUnit.MILLISECONDS).onBackpressureBuffer().subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe(l -> {
                L.d("Try to do action on activated: Locked: " + Display.isLocked());
                if (!Display.isLocked()) {
                    SocketManager.connect();
                    this.attachTimestampTimer();
                }
            });
        }
    }

    public void doOnDeactivated() {
        L.d("Do action on deactivated");
        if (this.activeActionDelayHolder != null && !this.activeActionDelayHolder.isUnsubscribed()) {
            this.activeActionDelayHolder.unsubscribe();
            this.activeActionDelayHolder = null;
        }
        SocketManager.disconnect();
        this.detachTimestampTimer();
    }

    public void attachTimestampTimer() {
        this.detachTimestampTimer();
        this.workingTimer = Observable.interval((long)60L, (TimeUnit)TimeUnit.SECONDS).onBackpressureBuffer().subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe(l -> TimerStore.get().now.set(TimeUtils.getCurrentTime()));
    }

    public void detachTimestampTimer() {
        if (this.workingTimer != null) {
            if (!this.workingTimer.isUnsubscribed()) {
                this.workingTimer.unsubscribe();
            }
            this.workingTimer = null;
        }
    }
}

