/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.bind;

import androidx.annotation.Nullable;
import com.zoyi.channel.plugin.android.bind.BindAction;
import com.zoyi.channel.plugin.android.bind.Binder;
import com.zoyi.channel.plugin.android.bind.BinderControllerInterface;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BinderCollection
implements BinderControllerInterface {
    private boolean isUnbinded = false;
    private List<Binder> binders = new ArrayList<Binder>();
    private Map<BindAction, Binder> binderMap = new HashMap<BindAction, Binder>();

    @Nullable
    private Binder get(BindAction action) {
        return this.binderMap.get((Object)action);
    }

    @Override
    public boolean isRunning(BindAction action) {
        Binder binder = this.get(action);
        return binder != null && binder.isRunning();
    }

    @Override
    public void bind(Binder binder) {
        this.binders.add(binder);
    }

    @Override
    public void bind(Binder binder, BindAction action) {
        this.unbind(action);
        if (!this.isUnbinded) {
            this.binderMap.put(action, binder);
        }
    }

    @Override
    public void unbind(BindAction action) {
        Binder binder = this.get(action);
        if (binder != null && binder.isRunning()) {
            binder.unbind();
        }
        this.binderMap.remove((Object)action);
    }

    @Override
    public void clear() {
        for (Binder binder : this.binders) {
            binder.unbind();
        }
        for (Binder binder : this.binderMap.values()) {
            binder.unbind();
        }
        this.binders.clear();
        this.binderMap.clear();
    }

    @Override
    public void unbindAll() {
        this.isUnbinded = true;
        this.clear();
    }
}

