/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.photo_album;

import android.animation.Animator;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.view.View;
import android.widget.ImageButton;
import android.widget.TextView;
import androidx.viewpager.widget.ViewPager;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.base.BaseActivity2;
import com.zoyi.channel.plugin.android.activity.download.DownloadActivity;
import com.zoyi.channel.plugin.android.activity.photo_album.PhotoAlbumPagerAdapter;
import com.zoyi.channel.plugin.android.activity.photo_album.PhotoAlbumStorage;
import com.zoyi.channel.plugin.android.enumerate.Transition;
import com.zoyi.channel.plugin.android.model.entity.FileMeta;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.IntentUtils;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.UIUtils;
import com.zoyi.channel.plugin.android.view.external.photoview.PhotoViewAttacher;
import com.zoyi.channel.plugin.android.view.layout.PhotoViewPager;
import com.zoyi.com.annimon.stream.Stream;
import java.util.List;

public class PhotoAlbumActivity
extends BaseActivity2
implements View.OnClickListener,
PhotoViewAttacher.OnPhotoTapListener {
    private static final int ANIMATION_DURATION = 200;
    private View layoutOverlay;
    private TextView pageInfoText;
    private ImageButton downloadButton;
    private ImageButton copyLinkButton;
    private ImageButton closeButton;
    private boolean menuVisible = true;
    private PhotoViewPager viewPager;
    private PhotoAlbumPagerAdapter adapter;
    private Animator.AnimatorListener animatorListener = new Animator.AnimatorListener(){

        public void onAnimationStart(Animator animator) {
            PhotoAlbumActivity.this.menuVisible = !PhotoAlbumActivity.this.menuVisible;
            if (PhotoAlbumActivity.this.menuVisible) {
                PhotoAlbumActivity.this.layoutOverlay.setVisibility(0);
            }
        }

        public void onAnimationEnd(Animator animator) {
            PhotoAlbumActivity.this.layoutOverlay.setVisibility(PhotoAlbumActivity.this.menuVisible ? 0 : 8);
        }

        public void onAnimationCancel(Animator animator) {
        }

        public void onAnimationRepeat(Animator animator) {
        }
    };

    @Override
    @Initializer
    protected boolean onCreate() {
        this.init(R.layout.ch_plugin_activity_photo_album, -16777216, false);
        this.layoutOverlay = this.findViewById(R.id.ch_layoutPhotoAlbumImage);
        this.viewPager = (PhotoViewPager)this.findViewById(R.id.ch_viewPagerPhotoAlbum);
        this.pageInfoText = (TextView)this.findViewById(R.id.ch_textPhotoAlbumPageInfo);
        this.copyLinkButton = (ImageButton)this.findViewById(R.id.ch_buttonPhotoAlbumCopyLink);
        this.downloadButton = (ImageButton)this.findViewById(R.id.ch_buttonPhotoAlbumDownload);
        this.closeButton = (ImageButton)this.findViewById(R.id.ch_buttonPhotoAlbumClose);
        this.downloadButton.setOnClickListener((View.OnClickListener)this);
        this.copyLinkButton.setOnClickListener((View.OnClickListener)this);
        this.closeButton.setOnClickListener((View.OnClickListener)this);
        Integer storageId = this.getInteger("storageId");
        String attachmentId = this.getString("attachementId");
        this.adapter = new PhotoAlbumPagerAdapter((Context)this, this);
        if (storageId == null || attachmentId == null) {
            return false;
        }
        List fileMetas = Stream.ofNullable(PhotoAlbumStorage.getInstance().get(storageId)).filter(file -> file != null).map(file -> file).toList();
        if (fileMetas != null && fileMetas.size() > 0) {
            int initIndex = this.findInitIndex(fileMetas, attachmentId);
            this.adapter.setItems(fileMetas);
            this.viewPager.setAdapter(this.adapter);
            this.viewPager.setCurrentItem(initIndex);
            this.viewPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)new ViewPager.SimpleOnPageChangeListener(){
                boolean init = true;

                public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
                    if (this.init && positionOffset == 0.0f && positionOffsetPixels == 0) {
                        this.onPageSelected(position);
                        this.init = false;
                    }
                    if (PhotoAlbumActivity.this.adapter != null) {
                        PhotoAlbumActivity.this.pageInfoText.setText((CharSequence)(position + 1 + " / " + PhotoAlbumActivity.this.adapter.getCount()));
                    }
                }
            });
            return true;
        }
        return false;
    }

    public void onClick(View view) {
        int id2 = view.getId();
        if (id2 == R.id.ch_buttonPhotoAlbumClose) {
            this.finish();
        }
        if (id2 == R.id.ch_buttonPhotoAlbumCopyLink) {
            this.copyLink();
        }
        if (id2 == R.id.ch_buttonPhotoAlbumDownload) {
            this.download();
        }
    }

    private void copyLink() {
        FileMeta fileMeta = this.adapter.getItem(this.viewPager.getCurrentItem());
        if (fileMeta != null) {
            try {
                ClipboardManager clipboard = (ClipboardManager)this.getSystemService("clipboard");
                ClipData clip = ClipData.newPlainText((CharSequence)"text", (CharSequence)fileMeta.getUrl());
                clipboard.setPrimaryClip(clip);
                UIUtils.showToast((Context)this, ResUtils.getString((Context)this, "ch.photo.url_copied_to_clipboard"));
            }
            catch (Exception ex) {
                UIUtils.showToast((Context)this, ResUtils.getString((Context)this, "ch.photo.read_file_info_failed"));
            }
        }
    }

    private void download() {
        FileMeta fileMeta = this.adapter.getItem(this.viewPager.getCurrentItem());
        if (fileMeta != null) {
            IntentUtils.setNextActivity((Context)this, DownloadActivity.class).putExtra("url", fileMeta.getUrl()).putExtra("filename", fileMeta.getName()).putExtra("EXTRA_TYPE", "image").setTransition(Transition.NONE).startActivity();
        }
    }

    public int findInitIndex(List<FileMeta> fileMetas, String attachmentId) {
        for (int i = 0; i < fileMetas.size(); ++i) {
            if (!fileMetas.get(i).getId().equals(attachmentId)) continue;
            return i;
        }
        return 0;
    }

    @Override
    public void onPhotoTap(View view, float x, float y) {
        this.animateOverlay();
    }

    @Override
    public void onOutsidePhotoTap() {
        this.animateOverlay();
    }

    private void animateOverlay() {
        this.layoutOverlay.animate().alpha(this.menuVisible ? 0.0f : 1.0f).setDuration(200L).setListener(this.animatorListener).start();
    }
}

