/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.download;

import android.app.Activity;
import android.content.Context;
import android.net.Uri;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.Toast;
import androidx.annotation.Nullable;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.base.BaseActivity2;
import com.zoyi.channel.plugin.android.activity.download.DownloadContract;
import com.zoyi.channel.plugin.android.activity.download.DownloadPresenter;
import com.zoyi.channel.plugin.android.enumerate.ButtonType;
import com.zoyi.channel.plugin.android.enumerate.Transition;
import com.zoyi.channel.plugin.android.util.FileUtils;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.rxpermission.RxPermissions;
import com.zoyi.channel.plugin.android.view.dialog.ChannelDialog;
import com.zoyi.channel.plugin.android.view.handler.SimpleAnimationListener;
import com.zoyi.channel.plugin.android.view.layout.DownloadProgressBar;

public class DownloadActivity
extends BaseActivity2
implements DownloadContract.View,
View.OnClickListener {
    private DownloadProgressBar progress;
    private View imageDone;
    private View buttonCancel;
    private DownloadContract.Presenter presenter;

    @Override
    @Initializer
    protected boolean onCreate() {
        this.init(R.layout.ch_plugin_activity_download, -16777216, false);
        this.progress = (DownloadProgressBar)this.findViewById(R.id.ch_progressDownload);
        this.imageDone = this.findViewById(R.id.ch_imageDownloadDone);
        this.buttonCancel = this.findViewById(R.id.ch_buttonDownloadCancel);
        this.buttonCancel.setOnClickListener((View.OnClickListener)this);
        this.presenter = new DownloadPresenter(this, (Activity)this);
        this.bindPresenter(this.presenter);
        if (this.getIntent() != null) {
            String url = this.getIntent().getStringExtra("url");
            String filename = this.getIntent().getStringExtra("filename");
            String type = this.getIntent().getStringExtra("EXTRA_TYPE");
            if (url != null && filename != null) {
                new RxPermissions((Activity)this).request("android.permission.WRITE_EXTERNAL_STORAGE").subscribe(granted -> {
                    if (granted.booleanValue() && this.presenter != null) {
                        this.presenter.download(url, filename, type);
                    } else {
                        this.finish(2);
                    }
                });
                return true;
            }
        }
        return false;
    }

    public void onBackPressed() {
    }

    @Override
    public void finish(int resultCode) {
        super.finish(resultCode, Transition.NONE);
    }

    protected void onPause() {
        super.onPause();
        this.overridePendingTransition(0, 0);
    }

    public void onClick(View view) {
        int id2 = view.getId();
        if (id2 == R.id.ch_buttonDownloadCancel) {
            this.presenter.cancel();
        }
        this.finish(1);
    }

    @Override
    public void onProgressUpdate(int progress) {
        this.progress.setProgress(progress);
    }

    @Override
    public void onError(@Nullable String message) {
        if (message != null) {
            ((ChannelDialog)((Object)new ChannelDialog((Context)this).setDescription(message).addButton(ButtonType.OK, v -> this.finish(2)))).show();
        } else {
            this.finish(2);
        }
    }

    @Override
    public void onDownloadComplete(Uri uri, String filename, boolean open) {
        this.imageDone.setVisibility(0);
        this.buttonCancel.setVisibility(8);
        this.progress.setVisibility(8);
        if (open) {
            try {
                FileUtils.openFile((Activity)this, uri);
            }
            catch (Exception ex) {
                Toast.makeText((Context)this, (CharSequence)ResUtils.getString("ch.chat.unknown_file"), (int)0).show();
            }
        }
        Animation animation = AnimationUtils.loadAnimation((Context)this, (int)R.anim.ch_plugin_dialog_in);
        animation.setAnimationListener((Animation.AnimationListener)new SimpleAnimationListener(){

            @Override
            public void onAnimationEnd(Animation animation) {
                DownloadActivity.this.finish(0);
            }
        });
        this.imageDone.startAnimation(animation);
    }
}

