/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.common.userchat.model;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.zoyi.channel.plugin.android.activity.common.chat.ChatContentType;
import com.zoyi.channel.plugin.android.activity.common.userchat.model.ChatItem;
import com.zoyi.channel.plugin.android.model.entity.ProfileEntity;
import com.zoyi.channel.plugin.android.model.rest.Button;
import com.zoyi.channel.plugin.android.model.rest.File;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.model.rest.MessageAction;
import com.zoyi.channel.plugin.android.model.rest.Session;
import com.zoyi.channel.plugin.android.model.rest.UserChat;
import com.zoyi.channel.plugin.android.store.ChannelStore;
import com.zoyi.com.annimon.stream.Optional;
import java.util.ArrayList;
import java.util.List;

public class UserChatItem
implements ChatItem {
    private UserChat userChat;
    @Nullable
    private Message message;
    @Nullable
    private Session session;
    @Nullable
    private ProfileEntity profileEntity;

    public UserChatItem(UserChat userChat, @Nullable Message message, @Nullable Session session, @Nullable ProfileEntity profileEntity) {
        this.userChat = userChat;
        this.message = message;
        this.session = session;
        this.profileEntity = profileEntity;
    }

    @Override
    @Nullable
    public String getId() {
        if (this.userChat != null) {
            return this.userChat.getId();
        }
        return null;
    }

    @Override
    @Nullable
    public ProfileEntity getProfile() {
        if (this.profileEntity != null) {
            return this.profileEntity;
        }
        return ChannelStore.get().channelState.get();
    }

    @Override
    @Nullable
    public Long getUpdatedAt() {
        if (this.userChat != null && this.userChat.isStateClosed() && this.userChat.getClosedAt() != null) {
            return this.userChat.getClosedAt();
        }
        if (this.userChat != null && this.userChat.getUpdatedAt() != null) {
            return this.userChat.getUpdatedAt();
        }
        return null;
    }

    @Override
    @Nullable
    public String getState() {
        return (String)Optional.ofNullable((Object)this.message).map(Message::getState).orElse(null);
    }

    @Override
    public boolean isDelete() {
        return (Boolean)Optional.ofNullable((Object)this.message).map(Message::isDeleted).orElse((Object)false);
    }

    @Override
    public boolean hasReview() {
        return (Boolean)Optional.ofNullable((Object)this.userChat).map(uc -> uc.getReview() != null).orElse((Object)false);
    }

    @Override
    public boolean requestReview() {
        return (Boolean)Optional.ofNullable((Object)this.message).map(Message::getAction).map(MessageAction::getType).map("userChat.close"::equals).orElse((Object)false);
    }

    @Override
    public boolean isClosed() {
        return (Boolean)Optional.ofNullable((Object)this.userChat).map(UserChat::isStateClosed).orElse((Object)false);
    }

    @Override
    @NonNull
    public List<File> getFiles() {
        return (List)Optional.ofNullable((Object)this.message).map(Message::getFiles).orElse(new ArrayList());
    }

    @Override
    @NonNull
    public List<Button> getLinkButtons() {
        return (List)Optional.ofNullable((Object)this.message).map(Message::getButtons).orElse(new ArrayList());
    }

    @Override
    @Nullable
    public String getPlainText() {
        return (String)Optional.ofNullable((Object)this.message).map(Message::getPlainText).filter(it -> !it.isEmpty()).orElse(null);
    }

    @Override
    public int getAlert() {
        if (this.session != null && this.session.getAlert() != null) {
            return this.session.getAlert();
        }
        return 0;
    }

    @Override
    @Nullable
    public String getSubKey() {
        if (this.userChat != null) {
            return this.userChat.getId();
        }
        return null;
    }

    @Override
    public ChatContentType getType() {
        return ChatContentType.USER_CHAT;
    }
}

