/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat.viewholder;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.Nullable;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.listener.viewholder.OnBaseMessageActionListener;
import com.zoyi.channel.plugin.android.activity.chat.view.viewholder.ActionButtonView;
import com.zoyi.channel.plugin.android.activity.chat.viewholder.BaseMessageHolder;
import com.zoyi.channel.plugin.android.model.entity.PersonEntity;
import com.zoyi.channel.plugin.android.model.entity.ProfileEntity;
import com.zoyi.channel.plugin.android.model.rest.ActionButton;
import com.zoyi.channel.plugin.android.model.rest.Marketing;
import com.zoyi.channel.plugin.android.selector.ProfileSelector;
import com.zoyi.channel.plugin.android.util.ListUtils;
import com.zoyi.channel.plugin.android.view.layout.AvatarLayout;
import com.zoyi.channel.plugin.android.view.layout.ChEndFlowLayout;
import com.zoyi.com.annimon.stream.Optional;
import com.zoyi.com.bumptech.glide.Glide;
import java.util.List;

public abstract class AbsHostMessageHolder
extends BaseMessageHolder {
    private AvatarLayout avatarHostMessage;
    private TextView textHostName;
    private ChEndFlowLayout layoutActionButtons;

    AbsHostMessageHolder(View itemView, @Nullable OnBaseMessageActionListener listener) {
        super(itemView, listener);
        this.avatarHostMessage = (AvatarLayout)itemView.findViewById(R.id.ch_avatarMessageHolder);
        this.textHostName = (TextView)itemView.findViewById(R.id.ch_textMessageHolderName);
        this.layoutActionButtons = (ChEndFlowLayout)itemView.findViewById(R.id.chLayoutMessageContentActionButtons);
    }

    public final void bind(@Nullable PersonEntity person, Long createdAt, boolean showDate, boolean isHead, boolean isTail) {
        super.bind(createdAt, showDate, isHead, isTail);
        ProfileEntity profile = (ProfileEntity)Optional.ofNullable((Object)person).map(p -> ProfileSelector.getProfile(p.getPersonType(), p.getPersonId())).orElse(null);
        if (isHead && profile != null) {
            if (this.avatarHostMessage != null) {
                this.avatarHostMessage.setVisibility(0);
                this.avatarHostMessage.set(profile);
            }
            if (this.textHostName != null) {
                this.textHostName.setText((CharSequence)Optional.ofNullable((Object)profile).map(ProfileEntity::getName).orElse(null));
            }
        } else {
            if (this.avatarHostMessage != null) {
                this.avatarHostMessage.setVisibility(4);
            }
            if (this.textHostName != null) {
                this.textHostName.setText(null);
            }
        }
    }

    @Override
    @Nullable
    protected Marketing getMarketing() {
        return null;
    }

    protected void setActionButtons(@Nullable String actionType, @Nullable List<ActionButton> buttons) {
        this.layoutActionButtons.removeAllViews();
        if (actionType != null && ListUtils.hasItems(buttons) && this.layoutActionButtons != null) {
            this.layoutActionButtons.setVisibility(0);
            for (ActionButton actionButton : buttons) {
                this.layoutActionButtons.addView((View)new ActionButtonView(this.context, actionType, actionButton, this));
            }
        } else if (this.layoutActionButtons != null) {
            this.layoutActionButtons.setVisibility(8);
        }
    }

    protected static View getItemView(ViewGroup parent) {
        return LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.ch_holder_host_message, parent, false);
    }

    @Override
    protected void onRecycled() {
        super.onRecycled();
        if (this.avatarHostMessage != null) {
            Glide.clear((View)this.avatarHostMessage);
        }
    }
}

