/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat.view.profilebot;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatImageView;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.view.profilebot.BaseProfileBotInputView;
import com.zoyi.channel.plugin.android.enumerate.FetchState;
import com.zoyi.channel.plugin.android.store.ProfileBotStore;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.ParseUtils;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.Views;
import com.zoyi.channel.plugin.android.view.layout.ChBorderLayout;
import com.zoyi.channel.plugin.android.view.layout.WatchedEditText;

public class ProfileBotInputNumberView
extends BaseProfileBotInputView {
    private ChBorderLayout borderLayout;
    private WatchedEditText editText;
    private View progressView;
    private View button;
    private AppCompatImageView imageSubmit;
    private FetchState fetchState = FetchState.COMPLETE;

    public ProfileBotInputNumberView(@NonNull Context context) {
        super(context);
    }

    public ProfileBotInputNumberView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public ProfileBotInputNumberView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    @Initializer
    public void initView(View root) {
        this.borderLayout = (ChBorderLayout)root.findViewById(R.id.ch_rootProfileBotInputNumberView);
        this.editText = (WatchedEditText)root.findViewById(R.id.ch_editProfileBotInputNumber);
        this.progressView = root.findViewById(R.id.ch_progressProfileBotInputNumber);
        this.button = root.findViewById(R.id.ch_buttonProfileBotInputNumber);
        this.imageSubmit = (AppCompatImageView)root.findViewById(R.id.ch_imageProfileBotInputNumberSubmit);
        this.editText.setOnFocusChangeListener((v, hasFocus) -> {
            this.resolveBorder(hasFocus);
            ProfileBotStore.get().requestFocus.set(true);
        });
        this.button.setOnClickListener(v -> this.submit());
    }

    @Override
    @Nullable
    public Object getValue() {
        Object number;
        if (this.editText != null && (number = ParseUtils.parseNumber(this.editText.getString())) != null) {
            return number;
        }
        return null;
    }

    @Override
    public void restore(@Nullable Object value, FetchState fetchState) {
        this.fetchState = fetchState;
        Views.setVisibility(this.progressView, fetchState == FetchState.LOADING);
        Views.setVisibility(this.button, fetchState != FetchState.LOADING);
        this.editText.setEnabled(fetchState != FetchState.LOADING);
        this.imageSubmit.setColorFilter(ResUtils.getColor(fetchState == FetchState.FAILED ? R.color.ch_orange400 : R.color.ch_cobalt400));
        this.resolveBorder(this.editText.hasFocus());
        Object number = ParseUtils.parseNumber(value != null ? value.toString() : null);
        if (number != null) {
            this.editText.setText(number.toString());
            this.editText.setSelection(this.editText.getString().length());
        } else {
            this.editText.setText(null);
        }
    }

    private void resolveBorder(boolean hasFocus) {
        if (this.fetchState == FetchState.FAILED) {
            this.borderLayout.setBorderColor(ResUtils.getColor(R.color.ch_orange400));
        } else {
            this.borderLayout.setBorderColor(ResUtils.getColor(hasFocus ? R.color.ch_cobalt400 : R.color.ch_grey300));
        }
    }

    @Override
    public void focus() {
        this.editText.requestFocus();
    }

    @Override
    public int getLayoutId() {
        return R.layout.ch_view_profile_bot_input_number;
    }
}

