/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat.model;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.zoyi.channel.plugin.android.activity.chat.model.ChatMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.ConnectableMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.MessageItem;
import com.zoyi.channel.plugin.android.activity.chat.type.ContentType;
import com.zoyi.channel.plugin.android.activity.chat.type.MessageType;
import com.zoyi.channel.plugin.android.enumerate.SendingState;
import com.zoyi.channel.plugin.android.util.Utils;

public abstract class SendItem
extends ConnectableMessageItem
implements MessageItem {
    @Nullable
    private String chatId;
    @NonNull
    protected String requestId;
    @NonNull
    protected Long createdAt;
    @NonNull
    protected SendingState state;

    protected SendItem(@Nullable String chatId) {
        this(chatId, 0);
    }

    protected SendItem(@Nullable String chatId, int index) {
        this.createdAt = System.currentTimeMillis() + (long)index;
        this.requestId = this.generateRequestId();
        this.state = SendingState.WAITING;
        this.chatId = chatId;
    }

    public void renew() {
        this.createdAt = System.currentTimeMillis();
        this.requestId = this.generateRequestId();
        this.state = SendingState.WAITING;
    }

    public void doFail() {
        this.state = SendingState.FAIL;
    }

    private String generateRequestId() {
        return this.createdAt + Utils.getRandomString(4);
    }

    @Override
    public String getSecondaryKey() {
        return this.requestId;
    }

    @NonNull
    public String getRequestId() {
        return this.requestId;
    }

    @Override
    @NonNull
    public Long getCreatedAt() {
        return this.createdAt;
    }

    @NonNull
    public SendingState getState() {
        return this.state;
    }

    @Nullable
    public String getChatId() {
        return this.chatId;
    }

    public void setChatId(@Nullable String chatId) {
        this.chatId = chatId;
    }

    @Override
    public boolean isSamePerson(@Nullable Object item) {
        if (item instanceof SendItem) {
            return true;
        }
        if (item instanceof ChatMessageItem) {
            return ((ChatMessageItem)item).getType() == MessageType.USER;
        }
        return false;
    }

    public abstract ContentType getContentType();

    public abstract boolean shouldShowTempMessage();

    public boolean equals(@Nullable Object o) {
        if (o instanceof SendItem) {
            SendItem next = (SendItem)o;
            return this.requestId.equals(next.requestId);
        }
        return false;
    }
}

