package com.zoyi.channel.plugin.android.view.youtube.ui.menu.defaultMenu;

import android.content.Context;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.PopupWindow;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.util.L;
import com.zoyi.channel.plugin.android.view.youtube.ui.menu.MenuItem;
import com.zoyi.channel.plugin.android.view.youtube.ui.menu.YouTubePlayerMenu;

import java.util.ArrayList;

public class DefaultYouTubePlayerMenu implements YouTubePlayerMenu {

  private Context context;

  private ArrayList<MenuItem> menuItems;

  @Nullable
  private PopupWindow popupWindow;

  public DefaultYouTubePlayerMenu(Context context) {
    this.context = context;

    menuItems = new ArrayList<>();
  }

  @Override
  public int getItemCount() {
    return menuItems.size();
  }

  @Override
  public void show(View anchorView) {
    popupWindow = createPopupWindow();
    popupWindow.showAsDropDown(
        anchorView,
        -context.getResources().getDimensionPixelSize(R.dimen.ch_ayp_8dp) * 12,
        -context.getResources().getDimensionPixelSize(R.dimen.ch_ayp_8dp) * 12
    );

    if (menuItems.size() == 0) {
      L.e("The menu is empty");
    }
  }

  @Override
  public void dismiss() {
    if (popupWindow != null) {
      popupWindow.dismiss();
    }
  }

  @Override
  public YouTubePlayerMenu addItem(MenuItem menuItem) {
    menuItems.add(menuItem);
    return this;
  }

  @Override
  public YouTubePlayerMenu removeItem(int itemIndex) {
    menuItems.remove(itemIndex);
    return this;
  }

  @Override
  public YouTubePlayerMenu removeItem(MenuItem menuItem) {
    menuItems.remove(menuItem);
    return this;
  }

  private PopupWindow createPopupWindow() {
    LayoutInflater inflater = (LayoutInflater) context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
    View view = inflater.inflate(R.layout.ch_plugin_ayp_player_menu, null);

    RecyclerView recyclerView = view.findViewById(R.id.ch_recyclerViewAypPlayerMenu);
    recyclerView.setLayoutManager(new LinearLayoutManager(context));
    recyclerView.setAdapter(new MenuAdapter(context, menuItems));
    recyclerView.setHasFixedSize(true);

    PopupWindow popupWindow = new PopupWindow(view, ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.WRAP_CONTENT);
    popupWindow.setContentView(view);
    popupWindow.setFocusable(true);
    popupWindow.setWidth(WindowManager.LayoutParams.WRAP_CONTENT);
    popupWindow.setHeight(WindowManager.LayoutParams.WRAP_CONTENT);

    return popupWindow;
  }
}
