package com.zoyi.channel.plugin.android.view.toast;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.animation.*;
import android.widget.FrameLayout;
import android.widget.TextView;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.store.SettingsStore;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.TimeUtils;

public class DateToastView extends FrameLayout {

  private TextView dateToast;

  public DateToastView(@NonNull Context context) {
    super(context);
    init(context);
  }

  public DateToastView(@NonNull Context context, @Nullable AttributeSet attrs) {
    super(context, attrs);
    init(context);
  }

  public DateToastView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);
    init(context);
  }

  @Initializer
  private void init(Context context) {
    View root = LayoutInflater.from(context).inflate(R.layout.ch_view_date_toast, this, true);

    dateToast = root.findViewById(R.id.ch_textDateToast);
  }

  public void show(@Nullable Long timestamp) {
    if (timestamp == null) {
      return;
    }

    if (dateToast != null) {
      dateToast.setText(TimeUtils.formatTranslatedDate(timestamp, SettingsStore.get().language.get()));

      clearAnimation();

      Animation animation = new AlphaAnimation(1f, 0f);
      animation.setInterpolator(new LinearInterpolator());
      animation.setStartOffset(1500);
      animation.setDuration(200);

      setAnimation(animation);
    }
  }
}
