package com.zoyi.channel.plugin.android.view.scrollview;

import android.content.Context;
import androidx.annotation.Nullable;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.LinearLayout;

abstract public class BottomPlaceholderLayout<E extends ViewGroup> extends LinearLayout {

  @Nullable
  private E scrollableViewGroup;

  private int height = 0;
  private int basePaddingBottom = 0;

  private boolean stackFromEnd = false;

  @Nullable
  private OnBottomPlaceholderHeightChangeListener listener;

  public BottomPlaceholderLayout(Context context) {
    super(context);
  }

  public BottomPlaceholderLayout(Context context, @Nullable AttributeSet attrs) {
    super(context, attrs);
  }

  public BottomPlaceholderLayout(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);
  }

  @Override
  protected void onSizeChanged(int w, int h, int oldw, int oldh) {
    super.onSizeChanged(w, h, oldw, oldh);

    this.height = h;

    handleScrollableViewPadding(scrollableViewGroup);

    if (listener != null) {
      listener.onHeightChange(h);
    }
  }

  public void setOnSizeChangeListener(OnBottomPlaceholderHeightChangeListener listener) {
    this.listener = listener;
  }

  @Override
  protected void onAttachedToWindow() {
    super.onAttachedToWindow();

    handleScrollableViewPadding(scrollableViewGroup);
  }

  protected void setScrollableView(@Nullable E scrollableViewGroup) {
    if (this.scrollableViewGroup == null && scrollableViewGroup != null) {
      this.scrollableViewGroup = scrollableViewGroup;
      this.scrollableViewGroup.setClipToPadding(false);
    }
  }

  public void setStackFromEnd(boolean stackFromEnd) {
    this.stackFromEnd = stackFromEnd;
  }

  protected abstract boolean canScroll(E scrollableView, int height);

  protected abstract boolean isOnBottom(E scrollableView);

  protected abstract void scrollToBottom(E scrollableView);

  private void handleScrollableViewPadding(@Nullable E view) {
    if (view != null) {
      boolean isOnBottom = isOnBottom(view);

      view.setPadding(
          view.getPaddingLeft(),
          view.getPaddingTop(),
          view.getPaddingRight(),
          height + basePaddingBottom
      );

      if (stackFromEnd && isOnBottom) {
        scrollToBottom(view);
      }
    }
  }

  public void setBasePaddingBottom(int basePaddingBottom) {
    this.basePaddingBottom = basePaddingBottom;

    handleScrollableViewPadding(scrollableViewGroup);
  }
}
