package com.zoyi.channel.plugin.android.view.integrations.instagram;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.viewpager.widget.PagerAdapter;

import android.view.View;
import android.view.ViewGroup;

import com.zoyi.channel.plugin.android.model.rest.media.instagram.InstagramData;
import com.zoyi.channel.plugin.android.model.rest.media.instagram.InstagramMediaEntity;

import java.util.ArrayList;
import java.util.List;

public class InstagramMediaAdapter extends PagerAdapter {

  private Context context;
  private ArrayList<InstagramMediaEntity> items = new ArrayList<>();

  private List<InstagramMediaView> views = new ArrayList<>();

  private boolean isVolumeOn = false;

  public InstagramMediaAdapter(Context context) {
    this.context = context;
  }

  public void setItems(InstagramData data) {
    this.items.clear();
    this.items.addAll(data.getData());

    this.views = new ArrayList<>();

    for (int i = 0; i < data.getData().size(); i++) {
      this.views.add(null);
    }

    notifyDataSetChanged();
  }

  public void onPageChanged(int position) {
    for (int i = 0; i < this.views.size(); i++) {
      InstagramMediaView view = this.views.get(i);

      if (view != null) {
        if (i == position) {
          view.onActive();
        } else {
          view.onDeactive();
        }
      }
    }
  }

  @Nullable
  private InstagramMediaEntity getItem(int position) {
    if (position >= 0 && position < this.items.size()) {
      return this.items.get(position);
    }
    return null;
  }

  public void changeVideoVolumeState(boolean isVolumeOn) {
    this.isVolumeOn = isVolumeOn;

    for (InstagramMediaView view : views) {
      if (view != null) {
        view.changeVideoVolumeState(isVolumeOn);
      }
    }
  }

  @Override
  public int getCount() {
    return this.items.size();
  }

  @Override
  public int getItemPosition(@NonNull Object object) {
    return POSITION_NONE;
  }

  @Override
  public boolean isViewFromObject(@NonNull View view, @NonNull Object o) {
    return view.equals(o);
  }

  @Override
  public void destroyItem(ViewGroup container, int position, Object object) {
    if (container != null && object instanceof View) {
      if (object instanceof InstagramMediaView) {
        ((InstagramMediaView) object).clear();
      }
      if (position < this.views.size()) {
        this.views.set(position, null);
      }
      container.removeView((View) object);
    }
  }

  @NonNull
  @Override
  public Object instantiateItem(@NonNull ViewGroup container, int position) {
    InstagramMediaView view = new InstagramMediaView(this.context);
    InstagramMediaEntity item = getItem(position);

    if (item != null) {
      view.setData(item, isVolumeOn);
    }

    container.addView(view);

    if (position < this.views.size()) {
      this.views.set(position, view);
    }

    return view;
  }
}
