package com.zoyi.channel.plugin.android.view.handler;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.zoyi.channel.plugin.android.util.Utils;

/**
 * Created by mika on 2016. 1. 22..
 */
public abstract class InfiniteScrollListener extends RecyclerView.OnScrollListener {

  private static int SCROLL_THRESHOLD = (int) Utils.dpToPx(200);

  @Override
  public void onScrolled(@NonNull RecyclerView recyclerView, int dx, int dy) {
    super.onScrolled(recyclerView, dx, dy);

    if (!recyclerView.canScrollVertically(1)) {
      scrollAttachedToBottom();
    } else if (!recyclerView.canScrollVertically(-1) || recyclerView.computeVerticalScrollOffset() < SCROLL_THRESHOLD) {
      scrollAttachedToTop();
    }
  }

  public abstract void scrollAttachedToBottom();

  public abstract void scrollAttachedToTop();
}
