package com.zoyi.channel.plugin.android.util;

import androidx.annotation.NonNull;
import android.text.SpannableStringBuilder;

import com.zoyi.channel.plugin.android.ChannelIO;
import com.zoyi.channel.plugin.android.model.rest.Plugin;
import com.zoyi.channel.plugin.android.open.option.Language;
import com.zoyi.channel.plugin.android.util.message.MessageParseOptions;
import com.zoyi.channel.plugin.android.util.message.MessageParserUtils;
import com.zoyi.com.annimon.stream.Optional;

/**
 * Created by jerry on 2018. 10. 23..
 */

public class MessageUtils {

  @NonNull
  public static CharSequence createWelcomeMessage(Plugin plugin, Language language) {
    SpannableStringBuilder builder = Optional.ofNullable(plugin)
        .map(Plugin::getWelcomeI18n)
        .map(i18n -> i18n.get(language.toString()))
        .map(text -> MessageParserUtils.parseText(text, getWelcomeMessageOption()))
        .orElse(null);

    if (builder != null) {
      return builder;
    }
    return ResUtils.getString(ChannelIO.getAppContext(), "ch.scripts.welcome_veil.default");
  }

  public static MessageParseOptions getWelcomeMessageOption() {
    return MessageParseOptions.MessageParseOptionsBuilder.create()
        .withEnableVariable(true)
        .build();
  }
}
