package com.zoyi.channel.plugin.android.store.state;

import androidx.annotation.Nullable;

import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;

public class CollectionState<E> extends BaseState<Collection<E>> {

  private ConcurrentLinkedQueue<E> list;

  public CollectionState() {
    super();
    this.list = new ConcurrentLinkedQueue<>();
  }

  public void set(Collection<E> list) {
    this.list.clear();
    this.list.addAll(list);

    post();
  }

  @Nullable
  @Override
  public Collection<E> get() {
    return this.list;
  }

  @Override
  public void reset() {
    this.list.clear();
  }
}
