package com.zoyi.channel.plugin.android.store.state;

import androidx.annotation.Nullable;
import com.zoyi.rx.Subscription;
import com.zoyi.rx.android.schedulers.AndroidSchedulers;
import com.zoyi.rx.functions.Action1;
import com.zoyi.rx.subjects.PublishSubject;

public abstract class BaseState<E> {

  private PublishSubject<E> publishSubject;

  BaseState() {
    this.publishSubject = PublishSubject.create();
  }

  public Subscription attach(Action1<E> action) {
    return publishSubject
        .onBackpressureBuffer()
        .observeOn(AndroidSchedulers.mainThread())
        .subscribe(action);
  }

  protected void post() {
    this.publishSubject.onNext(get());
  }

  @Nullable
  public abstract E get();

  public abstract void reset();
}
