package com.zoyi.channel.plugin.android.selector;

import androidx.annotation.Nullable;

import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.model.entity.ProfileEntity;
import com.zoyi.channel.plugin.android.model.rest.Bot;
import com.zoyi.channel.plugin.android.model.rest.Channel;
import com.zoyi.channel.plugin.android.model.rest.Manager;
import com.zoyi.channel.plugin.android.store.BotStore;
import com.zoyi.channel.plugin.android.store.ChannelStore;
import com.zoyi.channel.plugin.android.store.ManagerStore;
import com.zoyi.channel.plugin.android.store.binder.Binder2;
import com.zoyi.channel.plugin.android.store.state.EntityMapState;
import com.zoyi.channel.plugin.android.store.state.State;
import com.zoyi.rx.functions.Action1;

public class ProfileSelector {

  public static Binder2 bindDefaultProfile(Action1<ProfileEntity> action1) {
    State<String> defaultBotIdState = BotStore.get().defaultBotId;
    EntityMapState<Bot> botsState = BotStore.get().bots;
    State<Channel> channelState = ChannelStore.get().channelState;

    return new Binder2<>(defaultBotIdState, channelState).bind((defaultBotId, channel) -> {
      if (defaultBotId != null) {
        Bot bot = botsState.get(defaultBotId);
        if (bot != null) {
          action1.call(bot);
          return;
        }
      }

      if (channel != null) {
        action1.call(channel);
      }
    });
  }

  @Nullable
  public static ProfileEntity getProfile(@Nullable String personType, @Nullable String personId) {
    State<Channel> channelState = ChannelStore.get().channelState;
    EntityMapState<Bot> botsState = BotStore.get().bots;
    EntityMapState<Manager> managersState = ManagerStore.get().managers;

    if (Const.MANAGER.equals(personType) && managersState.get(personId) != null) {
      return managersState.get(personId);
    } else if (Const.BOT.equals(personType) && botsState.get(personId) != null) {
      return botsState.get(personId);
    }
    return channelState.get();
  }
}
