package com.zoyi.channel.plugin.android.open.exception;

import android.os.Build;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;

import com.zoyi.channel.plugin.android.global.Const;

public class ChannelException extends Exception {

  private ChannelException() {
  }

  private ChannelException(@Nullable String message) {
    super(message == null ? Const.EXCEPTION_UNKNOWN : message);
  }

  private ChannelException(String message, Throwable cause) {
    super(message, cause);
  }

  private ChannelException(Throwable cause) {
    super(cause);
  }

  @RequiresApi(api = Build.VERSION_CODES.N)
  private ChannelException(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
    super(message, cause, enableSuppression, writableStackTrace);
  }

  public static ChannelException newInstance(@Nullable String message) {
    return new ChannelException(message);
  }
}
