package com.zoyi.channel.plugin.android.model.rest;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.model.entity.Person;

/**
 * Created by mika on 2016. 12. 6..
 */
public class Manager implements Person {
  private String id;
  @Nullable
  private String name;
  @Nullable
  private String avatarUrl;

  @Override
  public String getId() {
    return id;
  }

  @NonNull
  @Override
  public String getName() {
    return name != null ? name : "";
  }

  @Nullable
  @Override
  public String getAvatarUrl() {
    return avatarUrl;
  }

  public final static String CLASSNAME = "manager";

  @Override
  public String getPersonType() {
    return Const.MANAGER;
  }

  @Override
  public String getPersonId() {
    return id;
  }
}
