package com.zoyi.channel.plugin.android.deserializer;

import com.zoyi.channel.plugin.android.model.repo.TranslationRepo;
import com.zoyi.channel.plugin.android.util.message.MessageParserUtils;
import com.zoyi.com.google.gson.*;

import java.lang.reflect.Type;

/**
 * Created by mika on 2018. 7. 11..
 */

public class TranslationRepoDeserializer implements JsonDeserializer {

  private Gson gson;

  public TranslationRepoDeserializer() {
    this.gson = new Gson();
  }

  @Override
  public Object deserialize(JsonElement json, Type type, JsonDeserializationContext jsonDeserializationContext)
      throws JsonParseException {

    TranslationRepo repo = gson.fromJson(json, type);

    if (repo != null && repo.getBlocks() != null) {
      MessageParserUtils.parseBlocks(repo.getBlocks());
    }
    return repo;
  }
}
