package com.zoyi.channel.plugin.android.bind;

import androidx.annotation.Nullable;

import java.util.*;

public class BinderCollection implements BinderControllerInterface {
  private boolean isUnbinded = false;

  private List<Binder> binders;
  private Map<BindAction, Binder> binderMap;

  public BinderCollection() {
    this.binders = new ArrayList<>();
    this.binderMap = new HashMap<>();
  }

  @Nullable
  private Binder get(BindAction action) {
    return binderMap.get(action);
  }

  @Override
  public boolean isRunning(BindAction action) {
    Binder binder = get(action);

    if (binder != null && binder.isRunning()) {
      return true;
    }
    return false;
  }

  @Override
  public void bind(Binder binder) {
    this.binders.add(binder);
  }

  @Override
  public void bind(Binder binder, BindAction action) {
    unbind(action);

    if (!this.isUnbinded) {
      this.binderMap.put(action, binder);
    }
  }

  @Override
  public void unbind(BindAction action) {
    Binder binder = get(action);

    if (binder != null && binder.isRunning()) {
      binder.unbind();
    }

    this.binderMap.remove(action);
  }

  @Override
  public void clear() {
    for (Binder binder : this.binders) {
      binder.unbind();
    }

    for (Binder binder : this.binderMap.values()) {
      binder.unbind();
    }

    this.binders.clear();
    this.binderMap.clear();
  }

  @Override
  public void unbindAll() {
    this.isUnbinded = true;

    clear();
  }
}
