package com.zoyi.channel.plugin.android.base;

import androidx.annotation.Nullable;

import com.zoyi.channel.plugin.android.bind.*;
import com.zoyi.channel.plugin.android.contract.BasePresenter;
import com.zoyi.channel.plugin.android.contract.BaseView;
import com.zoyi.channel.plugin.android.enumerate.ActionType;
import com.zoyi.channel.plugin.android.enumerate.Transition;
import com.zoyi.channel.plugin.android.global.Action;
import com.zoyi.rx.Subscription;

public abstract class AbstractPresenter<V extends BaseView> implements BasePresenter, BinderController {

  protected V view;

  private BinderCollection binderCollection;

  @Nullable
  private Subscription subscription;

  public AbstractPresenter(V view) {
    this.view = view;

    this.binderCollection = new BinderCollection();

    this.subscription = Action.observable().subscribe(actionType -> {
      handleBaseAction(actionType);
      handleAction(actionType);
    });
  }

  public abstract void init();

  @Override
  public BinderCollection getBinderCollection() {
    return binderCollection;
  }

  private void handleBaseAction(ActionType actionType) {
    switch (actionType) {
      case EXIT:
        view.finish(Transition.SLIDE_FROM_BOTTOM);
        break;

      case SHUTDOWN:
        view.finish(Transition.NONE);
        break;
    }
  }

  protected void handleAction(ActionType actionType) {
  }

  @Override
  public void release() {
    this.unbindAll();

    if (subscription != null && !subscription.isUnsubscribed()) {
      subscription.unsubscribe();
      subscription = null;
    }
  }
}
