package com.zoyi.channel.plugin.android.activity.settings.view;

import android.content.Context;
import androidx.annotation.Nullable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.selector.ChannelSelector;
import com.zoyi.channel.plugin.android.selector.PluginSelector;
import com.zoyi.channel.plugin.android.bind.Binder;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.view.layout.AvatarLayout;

public class SettingsHeaderView extends LinearLayout {

  private TextView textChannelName;
  private TextView textChannelUrl;
  private TextView textChannelDescription;

  private AvatarLayout avatarChannel;

  @Nullable
  private Binder channelBinder;

  @Nullable
  private Binder pluginBinder;

  public SettingsHeaderView(Context context) {
    super(context);
    init(context);
  }

  public SettingsHeaderView(Context context, @Nullable AttributeSet attrs) {
    super(context, attrs);
    init(context);
  }

  public SettingsHeaderView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);
    init(context);
  }

  @Initializer
  private void init(Context context) {
    View view = LayoutInflater.from(context).inflate(R.layout.ch_plugin_view_settings_header, this, true);

    textChannelName = view.findViewById(R.id.ch_textSettingsChannelName);
    textChannelUrl = view.findViewById(R.id.ch_textSettingsChannelUrl);
    textChannelDescription = view.findViewById(R.id.ch_textSettingsChannelDescription);
    avatarChannel = view.findViewById(R.id.ch_avatarSettingsChannel);
  }

  @Override
  protected void onAttachedToWindow() {
    super.onAttachedToWindow();

    channelBinder = ChannelSelector.bindChannel(channel -> {
      textChannelName.setText(channel.getName());

      textChannelUrl.setText(channel.getHomepageUrl());
      textChannelUrl.setVisibility(!TextUtils.isEmpty(channel.getHomepageUrl()) ? View.VISIBLE : View.GONE);

      textChannelDescription.setText(channel.getDescription());
      textChannelDescription.setVisibility(!TextUtils.isEmpty(channel.getDescription()) ? View.VISIBLE : View.GONE);

      avatarChannel.set(channel);
    });

    pluginBinder = PluginSelector.bindPlugin(plugin -> {
      textChannelName.setTextColor(plugin.getTextColor());
      textChannelUrl.setTextColor(plugin.getTextColor());
      textChannelDescription.setTextColor(plugin.getTextColor());
    });
  }

  @Override
  protected void onDetachedFromWindow() {
    super.onDetachedFromWindow();

    if (channelBinder != null) {
      channelBinder.unbind();
      channelBinder = null;
    }
    if (pluginBinder != null) {
      pluginBinder.unbind();
      pluginBinder = null;
    }
  }
}
