package com.zoyi.channel.plugin.android.activity.profile.view;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.TextView;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.action.CountryAction;
import com.zoyi.channel.plugin.android.activity.base.BaseActivity2;
import com.zoyi.channel.plugin.android.activity.chat.model.MobileNumber;
import com.zoyi.channel.plugin.android.model.rest.Country;
import com.zoyi.channel.plugin.android.network.RestSubscriber;
import com.zoyi.channel.plugin.android.network.RetrofitException;
import com.zoyi.channel.plugin.android.store.CountryStore;
import com.zoyi.channel.plugin.android.util.*;
import com.zoyi.channel.plugin.android.view.dialog.CountryCodeDialog;
import com.zoyi.channel.plugin.android.view.layout.WatchedEditText;
import com.zoyi.com.annimon.stream.Optional;

import java.util.List;
import java.util.Locale;

public class EditProfileMobileNumberView extends FrameLayout implements BaseEditProfileView {

  private View buttonSelectCountry;
  private TextView textCountry;
  private WatchedEditText editText;
  private View clearButton;

  private int countryCode = 1;

  public EditProfileMobileNumberView(@NonNull Context context) {
    super(context);

    init(context);
  }

  public EditProfileMobileNumberView(@NonNull Context context, @Nullable AttributeSet attrs) {
    super(context, attrs);

    init(context);
  }

  public EditProfileMobileNumberView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);

    init(context);
  }

  @Initializer
  @Override
  public void init(Context context) {
    View root = LayoutInflater.from(context).inflate(R.layout.ch_view_edit_profile_mobile_number, this, true);

    buttonSelectCountry = root.findViewById(R.id.ch_buttonEditProfileSelectCountry);
    textCountry = root.findViewById(R.id.ch_textEditProfileSelectCountry);
    editText = root.findViewById(R.id.ch_editEditProfileMobileNumber);
    clearButton = root.findViewById(R.id.ch_buttonEditProfileMobileNumberClearText);

    editText.setWatchedTextChangedListener(s -> Views.setVisibility(clearButton, !TextUtils.isEmpty(s)));
    clearButton.setOnClickListener(v -> editText.setText(null));
    buttonSelectCountry.setOnClickListener(v -> requestCountrySelector());
  }

  @Override
  public void focus() {
    if (editText != null) {
      editText.requestFocus();
    }
  }

  @Override
  public boolean isValidValue() {
    return true;
  }

  @Nullable
  @Override
  public Object getValue() {
    if (editText.getString().trim().isEmpty()) {
      return null;
    }
    return String.format(Locale.US, "+%d%s", countryCode, editText.getString());
  }

  @Override
  public void setValue(@Nullable Object value) {
    MobileNumber mobileNumber = new MobileNumber(Optional.ofNullable(value).map(Object::toString).orElse(null));

    countryCode = mobileNumber.getCountryCode();

    textCountry.setText(String.format(Locale.US, "+%d", mobileNumber.getCountryCode()));
    editText.setText(mobileNumber.getPhoneNumber());
  }

  private void requestCountrySelector() {
    List<Country> countries = CountryStore.get().countries.get();

    if (countries == null) {
      showProgress(ResUtils.getString(getContext(), "ch.loading_information"));

      CountryAction.fetchCountries(new RestSubscriber<List<Country>>() {
        @Override
        public void onError(RetrofitException error) {
          hideProgress();
        }

        @Override
        public void onSuccess(@NonNull List<Country> countries) {
          hideProgress();

          CountryStore.get().countries.set(countries);

          if (countries.size() > 0) {
            openCountrySelector(countries);
          }
        }
      });
    } else {
      openCountrySelector(countries);
    }
  }

  private void openCountrySelector(List<Country> countries) {
    new CountryCodeDialog(getContext(), countries, (position, countryCode) -> {
      try {
        this.countryCode = Integer.parseInt(countryCode);
        textCountry.setText(String.format("+%s", countryCode));
      } catch (Exception ignored) {
      }
    }).show();
  }

  private void showProgress(String message) {
    if (getContext() instanceof BaseActivity2) {
      ((BaseActivity2) getContext()).showProgress(message);
    }
  }

  private void hideProgress() {
    if (getContext() instanceof BaseActivity2) {
      ((BaseActivity2) getContext()).hideProgress();
    }
  }
}
