package com.zoyi.channel.plugin.android.activity.photo_album;

import androidx.annotation.Nullable;

import com.zoyi.channel.plugin.android.model.rest.File;
import com.zoyi.com.annimon.stream.Stream;

import java.util.ArrayList;
import java.util.List;

public class PhotoAlbumStorage {

  @Nullable
  private static PhotoAlbumStorage instance;

  public static PhotoAlbumStorage getInstance() {
    if (instance == null) {
      synchronized (PhotoAlbumStorage.class) {
        if (instance == null) {
          instance = new PhotoAlbumStorage();
        }
      }
    }
    return instance;
  }

  private int idCounter = 0;

  private ArrayList<File> files;

  private PhotoAlbumStorage() {
    files = new ArrayList<>();
  }

  public int save(List<File> files) {
    idCounter++;

    clear();
    if (files != null) {
      this.files.addAll(Stream.ofNullable(files)
          .filter(file -> file.isImage() && file.getUrl() != null)
          .toList());
    }

    return idCounter;
  }

  @Nullable
  public List<File> get(int id) {
    if (idCounter != id) {
      return null;
    }

    return this.files;
  }

  public void clear() {
    this.files.clear();
  }

  public void clear(int id) {
    if (idCounter == id) {
      this.files.clear();
    }
  }

  public ArrayList<File> getFiles() {
    return files;
  }
}
