package com.zoyi.channel.plugin.android.activity.language;

import android.app.Dialog;
import androidx.annotation.Nullable;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.base.BaseActivity2;
import com.zoyi.channel.plugin.android.activity.language.contract.LanguageSettingsContract;
import com.zoyi.channel.plugin.android.open.option.Language;
import com.zoyi.channel.plugin.android.util.*;

public class LanguageSettingsActivity extends BaseActivity2 implements LanguageSettingsContract.View {

  private LanguageSettingsContract.Presenter presenter;

  @Nullable
  private Dialog dialog;

  @Initializer
  @Override
  protected boolean onCreate() {
    init(R.layout.ch_plugin_activity_language_settings);

    findViewById(R.id.ch_textOptionLanguageKo).setOnClickListener(v -> changeLanguage(Language.KOREAN));
    findViewById(R.id.ch_textOptionLanguageJa).setOnClickListener(v -> changeLanguage(Language.JAPANESE));
    findViewById(R.id.ch_textOptionLanguageEn).setOnClickListener(v -> changeLanguage(Language.ENGLISH));

    presenter = new LanguageSettingsPresenter(this);

    bindPresenter(presenter);

    return true;
  }

  private void changeLanguage(Language language) {
    presenter.changeLanguage(language);
  }

  @Override
  public void showProgress(Language language) {
    hideProgress();

    dialog = ProgressHelper.show(
        this,
        ResUtils.getString(this, language, "ch.settings.changing_message"),
        false
    );
  }

  @Override
  public void hideProgress() {
    if (dialog != null && dialog.isShowing()) {
      dialog.dismiss();
      dialog = null;
    }
  }

  @Override
  public void onLanguageChange(Language language) {
    finish();
  }
}
