package com.zoyi.channel.plugin.android.activity.common.userchat.model;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.zoyi.channel.plugin.android.activity.common.chat.ChatContentType;
import com.zoyi.channel.plugin.android.model.entity.ProfileEntity;
import com.zoyi.channel.plugin.android.model.rest.Button;
import com.zoyi.channel.plugin.android.model.rest.File;

import java.util.List;

public interface ChatItem {

  @Nullable
  String getId();

  @Nullable
  ProfileEntity getProfile();

  @Nullable
  Long getUpdatedAt();

  int getAlert();

  @Nullable
  String getState();

  @Nullable
  String getSubKey();

  ChatContentType getType();

  // preview states

  boolean isDelete();

  boolean hasReview();

  boolean requestReview();

  boolean isClosed();

  @NonNull
  List<File> getFiles();

  @NonNull
  List<Button> getLinkButtons();

  @Nullable
  String getPlainText();
}
