package com.zoyi.channel.plugin.android.activity.chat.viewholder;

import androidx.annotation.Nullable;
import android.view.View;
import android.view.ViewGroup;

import com.zoyi.channel.plugin.android.activity.chat.listener.viewholder.OnBaseMessageActionListener;
import com.zoyi.channel.plugin.android.activity.chat.model.WelcomeMessageItem;
import com.zoyi.com.annimon.stream.Optional;

public class WelcomeMessageHolder extends AbsHostMessageHolder {

  private WelcomeMessageHolder(View itemView, @Nullable OnBaseMessageActionListener listener) {
    super(itemView, listener);
  }

  public void bind(WelcomeMessageItem item) {
    super.bind(item.getDefaultBot(), item.getCreatedAt(), true, true, true);

    setText(Optional.ofNullable(item.getParsedText()).orElse(null));
  }

  public static WelcomeMessageHolder newInstance(ViewGroup parent, @Nullable OnBaseMessageActionListener listener) {
    return new WelcomeMessageHolder(getItemView(parent), listener);
  }
}
