package com.zoyi.channel.plugin.android.activity.chat.viewholder;

import android.app.Dialog;
import androidx.annotation.Nullable;
import android.view.View;
import android.view.ViewGroup;

import com.zoyi.channel.plugin.android.activity.chat.listener.viewholder.OnMessageActionListener;
import com.zoyi.channel.plugin.android.activity.chat.model.ChatMessageItem;
import com.zoyi.channel.plugin.android.model.rest.*;
import com.zoyi.com.annimon.stream.Optional;

import java.util.List;

public class UserMessageHolder extends AbsUserMessageHolder {

  @Nullable
  private OnMessageActionListener listener;
  @Nullable
  private Message message;

  private UserMessageHolder(View itemView, @Nullable OnMessageActionListener listener) {
    super(itemView, listener);

    this.listener = listener;
  }

  public void bind(ChatMessageItem item, boolean showDate, boolean isHead, boolean isTail) {
    super.bind(item.getCreatedAt(), showDate, isHead, isTail);

    this.message = item.getMessage();

    String messageId = Optional.ofNullable(item.getMessage()).map(Message::getId).orElse(null);

    if (item.getMessage() != null) {
      if (item.getMessage().isDeleted()) {
        setDeleteMessage();
      } else {
        // set text
        if (item.getMessage() != null && item.getMessage().getBlocks() != null) {
          if (item.getMessage().getBlocks().size() == 1 && item.getMessage().getBlocks().get(0).hasOnlyEmoji()) {
            setGiantEmoji(item.getMessage().getBlocks().get(0));
          } else {
            setBlocks(item.getMessage().getBlocks());
          }
        }

        // set web page
        Optional.ofNullable(item.getMessage()).map(Message::getWebPage).ifPresent(webPage -> setWebPage(messageId, webPage));

        setAttachments(
            Optional.ofNullable(item.getMessage()).map(Message::getId).orElse(null),
            item.getMessage().getFiles(),
            this
        );

        setReactions(item.getMessage().getReactions());
      }
    }
  }

  @Override
  protected void setText(@Nullable CharSequence text) {
    super.setText(text);
    if (textMessage != null) {
      textMessage.setAlpha(1f);
    }
  }

  @Override
  protected void setBlocks(@Nullable List<Block> blocks) {
    super.setBlocks(blocks);
    if (textMessage != null) {
      textMessage.setAlpha(1f);
    }
  }

  @Override
  protected void setLinkButtons(@Nullable List<Button> buttons) {
    super.setLinkButtons(buttons);
    if (textMessage != null) {
      textMessage.setAlpha(1f);
    }
  }

  @Override
  protected void setDeleteMessage() {
    super.setDeleteMessage();
    if (textMessage != null) {
      textMessage.setAlpha(0.5f);
    }
  }

  @Override
  public boolean onLongClick(View v) {
    if (listener != null && message != null) {
      Dialog dialog = listener.onMessageLongClick(message);
      if (dialog != null) {
        dialog.show();
        return true;
      }
    }
    return false;
  }

  @Override
  public void onWebPageLongClick() {
    if (listener != null && message != null) {
      Dialog dialog = listener.onMessageLongClick(message);
      if (dialog != null) {
        dialog.show();
      }
    }
  }

  @Override
  protected void onReactionsLongClicked() {
    if (listener != null && message != null && message.getReactions() != null && message.getReactions().size() > 0) {
      listener.onReactionsLongClicked(message.getReactions());
    }
  }

  @Override
  public void onAttachmentClick(File attachment) {
    super.onAttachmentClick(attachment);

    if (listener != null && message != null) {
      listener.onAttachmentClick(attachment, message);
    }
  }

  @Override
  public void onAttachmentLongClick() {
    if (listener != null && message != null) {
      Dialog dialog = listener.onMessageLongClick(message);
      if (dialog != null) {
        dialog.show();
      }
    }
  }

  @Override
  public void onLinkButtonLongClick() {
    if (listener != null && message != null) {
      Dialog dialog = listener.onMessageLongClick(message);
      if (dialog != null) {
        dialog.show();
      }
    }
  }

  public static UserMessageHolder newInstance(ViewGroup parent, @Nullable OnMessageActionListener listener) {
    return new UserMessageHolder(getItemView(parent), listener);
  }

  @Override
  protected void onRecycled() {
    super.onRecycled();

    this.message = null;
  }
}
