package com.zoyi.channel.plugin.android.activity.chat.viewholder;

import androidx.annotation.Nullable;
import android.view.View;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.model.SendItem;
import com.zoyi.channel.plugin.android.activity.chat.listener.viewholder.OnSendingActionListener;
import com.zoyi.channel.plugin.android.enumerate.SendingState;
import com.zoyi.channel.plugin.android.util.Views;

public class AbsSendingMessageHolder extends AbsUserMessageHolder {

  private View buttonResend;

  @Nullable
  private SendItem item;

  AbsSendingMessageHolder(View itemView, @Nullable OnSendingActionListener listener) {
    super(itemView, listener);

    buttonResend = itemView.findViewById(R.id.ch_buttonMessageHolderResend);

    if (buttonResend != null && listener != null) {
      buttonResend.setOnClickListener(v -> {
        if (item != null) {
          listener.onResendButtonClick(item);
        }
      });
    }
  }

  public void bind(SendItem item, boolean isTail) {
    super.bind(item.getCreatedAt(), false, false, isTail);

    this.item = item;

    Views.setVisibility(buttonResend, item.getState() == SendingState.FAIL, View.INVISIBLE);
  }
}
