package com.zoyi.channel.plugin.android.activity.chat.view.profilebot;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import android.widget.TextView;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.enumerate.FetchState;
import com.zoyi.channel.plugin.android.util.*;
import com.zoyi.channel.plugin.android.view.dialog.DatetimeDialog;
import com.zoyi.com.annimon.stream.Optional;

public class ProfileBotInputDateView extends BaseProfileBotInputView {

  public ProfileBotInputDateView(@NonNull Context context) {
    super(context);
  }

  public ProfileBotInputDateView(@NonNull Context context, @Nullable AttributeSet attrs) {
    super(context, attrs);
  }

  public ProfileBotInputDateView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);
  }

  private View button;
  private TextView textView;
  private View progress;
  private View dropdown;

  @Nullable
  private DatetimeDialog dialog;

  @Nullable
  private Long timestamp;

  @Initializer
  @Override
  public void initView(View root) {
    button = root.findViewById(R.id.ch_buttonProfileBotInputDate);
    textView = root.findViewById(R.id.ch_textProfileBotInputDate);
    progress = root.findViewById(R.id.ch_progressProfileBotInputDate);
    dropdown = root.findViewById(R.id.ch_imageProfileBotInputDateDropdown);

    button.setOnClickListener(v -> {
      this.dialog = new DatetimeDialog(getContext());
      this.dialog.show(timestamp, this::submit);
    });
  }

  @Nullable
  @Override
  public Object getValue() {
    // send information directly so not used
    return null;
  }

  @Override
  public void restore(@Nullable Object value, FetchState fetchState) {
    this.timestamp = ParseUtils.parseLong(value);

    textView.setText(Optional.ofNullable(this.timestamp).map(TimeUtils::formatDatetime).orElse(null));

    Views.setVisibility(progress, fetchState == FetchState.LOADING);
    Views.setVisibility(dropdown, fetchState != FetchState.LOADING);
  }

  @Override
  public void focus() {
    // do nothing
  }

  @Override
  public void onRecycled() {
    super.onRecycled();

    if (this.dialog != null && this.dialog.isShowing()) {
      this.dialog.dismiss();
      this.dialog = null;
    }
  }

  @Override
  public int getLayoutId() {
    return R.layout.ch_view_profile_bot_input_date;
  }
}
