package com.zoyi.channel.plugin.android.activity.chat.dialog;

import androidx.annotation.NonNull;
import android.view.*;
import android.widget.TextView;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.base.adapter.BaseViewHolder;
import com.zoyi.channel.plugin.android.model.rest.Manager;
import com.zoyi.channel.plugin.android.view.layout.AvatarLayout;

public class ReactionManagerHolder extends BaseViewHolder {

  private AvatarLayout avatar;
  private TextView textName;

  public ReactionManagerHolder(@NonNull View itemView) {
    super(itemView);

    avatar = itemView.findViewById(R.id.ch_avatarReactionManager);
    textName = itemView.findViewById(R.id.ch_textReactionManagerName);
  }

  public void bindManager(Manager manager) {

    if (avatar != null) {
      avatar.setVisibility(View.VISIBLE);
      avatar.set(manager);
    }

    textName.setText(manager.getName());
  }

  public static ReactionManagerHolder newInstance(ViewGroup parent) {
    return new ReactionManagerHolder(LayoutInflater.from(parent.getContext()).inflate(R.layout.ch_holder_reaction_manager, parent, false));
  }
}
