package com.zoyi.channel.plugin.android.action;

import androidx.annotation.Nullable;

import com.zoyi.channel.plugin.android.global.Api;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.model.rest.Marketing;
import com.zoyi.channel.plugin.android.model.rest.User;
import com.zoyi.channel.plugin.android.network.RestSubscriber;
import com.zoyi.channel.plugin.android.store.UserStore;

public class MarketingAction {

  public static void sendClickEvent(@Nullable Marketing marketing, @Nullable String url) {
    User user = UserStore.get().user.get();

    if (marketing != null && marketing.getType() != null && user != null && user.getId() != null) {
      switch (marketing.getType()) {
        case Const.MARKETING_TYPE_CAMPAIGN:
          Api.sendCampaignClickEvent(marketing.getId(), user.getId(), url).run(new RestSubscriber<>());
          break;
        case Const.MARKETING_TYPE_ONE_TIME_MSG:
          Api.oneTimeMsgClick(marketing.getId(), user.getId(), url).run(new RestSubscriber<>());
          break;
      }
    }
  }

  public static void sendViewEvent(@Nullable Marketing marketing) {
    if (marketing != null && marketing.getId() != null && marketing.getType() != null) {
      switch (marketing.getType()) {
        case Const.MARKETING_TYPE_CAMPAIGN:
          Api.sendCampaignViewEvent(marketing.getId()).run(new RestSubscriber<>());
          break;
        case Const.MARKETING_TYPE_ONE_TIME_MSG:
          Api.oneTimeMsgView(marketing.getId()).run(new RestSubscriber<>());
          break;
      }
    }
  }
}
