package com.zoyi.channel.plugin.android;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.util.L;

/**
 * @deprecated Use {@link com.zoyi.channel.plugin.android.open.config.BootConfig}
 */
@Deprecated
public class ChannelPluginSettings {

  @Nullable
  private String pluginKey;
  @Nullable
  private String memberId;
  @Nullable
  private String memberHash;

  private boolean debugMode;
  private boolean enabledTrackDefaultEvent;
  private boolean hideDefaultInAppPush;

  @Nullable
  private Boolean unsubscribed;
  @Nullable
  private CHLocale locale;
  @Nullable
  private LauncherConfig launcherConfig;

  /**
   * @param pluginKey
   * @deprecated Use {@link com.zoyi.channel.plugin.android.open.config.BootConfig#create(String)}
   */
  @Deprecated
  public ChannelPluginSettings(@Nullable String pluginKey) {
    this.pluginKey = pluginKey;
    this.debugMode = false;
    this.enabledTrackDefaultEvent = Const.DEFAULT_SETTINGS_TRACK_DEFAULT_EVENT;
    this.hideDefaultInAppPush = Const.DEFAULT_SETTINGS_HIDE_POPUP;
    this.locale = null;
  }

  /**
   * @param pluginKey
   * @return channel plugin settings
   * @deprecated Use {@link com.zoyi.channel.plugin.android.open.config.BootConfig#create(String)}
   */
  @Deprecated
  public static ChannelPluginSettings create(@Nullable String pluginKey) {
    L.w("ChannelPluginSettings.create is deprecated. Please use BootConfig.create");

    return new ChannelPluginSettings(pluginKey);
  }

  public void setPluginKey(@Nullable String pluginKey) {
    this.pluginKey = pluginKey;
  }

  public ChannelPluginSettings setMemberId(@Nullable String memberId) {
    this.memberId = memberId;
    return this;
  }

  public ChannelPluginSettings setMemberHash(@Nullable String memberHash) {
    this.memberHash = memberHash;

    return this;
  }

  public ChannelPluginSettings setUnsubscribed(boolean unsubscribed) {
    this.unsubscribed = unsubscribed;

    return this;
  }

  public ChannelPluginSettings setDebugMode(@Nullable Boolean debug) {
    if (debug != null) {
      this.debugMode = debug;
    }
    return this;
  }

  public ChannelPluginSettings setEnabledTrackDefaultEvent(@Nullable Boolean enabledTrackDefaultEvent) {
    if (enabledTrackDefaultEvent != null) {
      this.enabledTrackDefaultEvent = enabledTrackDefaultEvent;
    }
    return this;
  }

  public ChannelPluginSettings setHideDefaultInAppPush(@Nullable Boolean hideDefaultInAppPush) {
    if (hideDefaultInAppPush != null) {
      this.hideDefaultInAppPush = hideDefaultInAppPush;
    }
    return this;
  }

  public ChannelPluginSettings setLocale(@Nullable CHLocale locale) {
    this.locale = locale;
    return this;
  }

  public ChannelPluginSettings setLauncherConfig(@Nullable LauncherConfig launcherConfig) {
    this.launcherConfig = launcherConfig;
    return this;
  }

  @Nullable
  public String getPluginKey() {
    return pluginKey;
  }

  @Nullable
  public String getMemberId() {
    return memberId;
  }

  @Nullable
  public String getMemberHash() {
    return memberHash;
  }

  @Nullable
  public Boolean getUnsubscribed() {
    return unsubscribed;
  }

  public boolean isDebugMode() {
    return debugMode;
  }

  public boolean isEnabledTrackDefaultEvent() {
    return enabledTrackDefaultEvent;
  }

  public boolean isHideDefaultInAppPush() {
    return hideDefaultInAppPush;
  }

  @NonNull
  public CHLocale getLocale() {
    if (locale != null) {
      return locale;
    }
    return CHLocale.getDeviceLocale();
  }

  @Nullable
  public LauncherConfig getLauncherConfig() {
    return launcherConfig;
  }
}
