package com.zoyi.channel.plugin.android.view.media_thumbnail;

import android.content.Context;
import android.graphics.Point;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;

import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.model.rest.File;
import com.zoyi.channel.plugin.android.model.rest.WebPage;
import com.zoyi.channel.plugin.android.util.UriUtils;
import com.zoyi.channel.plugin.android.view.video_player.AbsVideoPlayerView;

public abstract class AbsPopUpMediaThumbnailView extends MediaThumbnailView {

  public AbsPopUpMediaThumbnailView(@NonNull Context context) {
    super(context);

    init(context);
  }

  public AbsPopUpMediaThumbnailView(@NonNull Context context, @Nullable AttributeSet attrs) {
    super(context, attrs);

    init(context);
  }

  public AbsPopUpMediaThumbnailView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);

    init(context);
  }

  private Context context;

  @Nullable
  private String messageId;
  @Nullable
  private File attachment = null;
  @Nullable
  private WebPage webPage;

  @Nullable
  private OnClickListener listener;

  private void init(Context context) {
    this.context = context;
  }

  public void setAttachment(
      @Nullable String messageId,
      File attachment
  ) {
    clear();
    this.webPage = null;

    this.messageId = messageId;
    this.attachment = attachment;

    if (messageId != null && attachment.getUrl() != null) {
      if (attachment.isVideo()) {
        onPlayClick();
      } else if (attachment.isImage()) {
        Point imageSize = getImageSize(attachment.getWidth(), attachment.getHeight());
        setImage(attachment.getThumbnailURL(imageSize), imageSize.x, imageSize.y);
      }
    }
  }

  public void setWebPage(@Nullable String messageId, WebPage webPage) {
    clear();

    this.attachment = null;

    this.messageId = messageId;
    this.webPage = webPage;

    setImage(webPage.getPreviewUrl());

    if (Const.PUBLISHER_YOUTUBE.equals(webPage.getPublisher())) {
      activatePlayButton();
      onPlayClick();
    }
  }

  @Override
  public void onPlayClick() {
    if (messageId != null && listener != null) {
      if (webPage != null && webPage.getId() != null && webPage.getUrl() != null ) {
        super.onPlayClick();

        String videoId = UriUtils.getYouTubeVideoId(webPage.getUrl());

        if (Const.PUBLISHER_YOUTUBE.equals(webPage.getPublisher()) && videoId != null) {
          appendVideoView(createYoutubePlayerView(context, messageId, webPage.getId(), videoId, listener));
        }
      }

      if (attachment != null) {
        super.onPlayClick();

        AbsVideoPlayerView view = createVideoPlayerView(context, messageId, attachment, listener);
        if (view != null) {
          appendVideoView(view);
        }
      }
    }
  }

  public void setOnPopupClickListener(@Nullable OnClickListener listener) {
    this.listener = listener;
  }

  @Override
  protected void onDetachedFromWindow() {
    super.onDetachedFromWindow();
    clear();
  }

  @Override
  public void clear() {
    super.clear();

    this.attachment = null;
    this.webPage = null;
  }

  protected abstract Point getImageSize(float width, float height);

  @Nullable
  protected abstract AbsVideoPlayerView createVideoPlayerView(Context context, String messageId, File attachment, OnClickListener listener);

  protected abstract AbsVideoPlayerView createYoutubePlayerView(
      Context context,
      String messageId,
      String webPageId,
      String videoId,
      OnClickListener listener
  );
}
